/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.carriage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector4f;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageBlock;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonCarriageRenderer
extends EntityRenderer<CannonCarriageEntity> {
    public CannonCarriageRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CannonCarriageEntity carriage, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light) {
        VertexConsumer vcons = buffers.m_6299_(RenderType.m_110457_());
        boolean cannonRider = carriage.isCannonRider();
        BlockState state = (BlockState)CBCBlocks.CANNON_CARRIAGE.getDefaultState().m_61124_((Property)CannonCarriageBlock.SADDLED, (Comparable)Boolean.valueOf(cannonRider));
        SuperByteBuffer carriageBuf = CachedBuffers.partial((PartialModel)(cannonRider ? CBCBlockPartials.CANNON_CARRIAGE_SADDLE : CBCBlockPartials.CANNON_CARRIAGE), (BlockState)state);
        SuperByteBuffer axleBuf = CachedBuffers.partial((PartialModel)CBCBlockPartials.CANNON_CARRIAGE_AXLE, (BlockState)state);
        SuperByteBuffer wheelBuf = CachedBuffers.partial((PartialModel)CBCBlockPartials.CANNON_CARRIAGE_WHEEL, (BlockState)state);
        float yawRad = (float)Math.PI - entityYaw * ((float)Math.PI / 180);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        ((SuperByteBuffer)carriageBuf.translate(-0.5, 0.0, -0.5)).light(light).renderInto(stack, vcons);
        ((SuperByteBuffer)((SuperByteBuffer)axleBuf.translate(-0.5, 0.84375, -0.5)).rotateCentered(carriage.m_146909_() * ((float)Math.PI / 180), Direction.EAST)).light(light).renderInto(stack, vcons);
        Vector4f oldWheel = carriage.previousWheelState;
        Vector4f newWheel = carriage.getWheelState();
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheelBuf.translate(-0.6875, 0.25, -0.15625)).rotateXDegrees(90.0f)).rotateZDegrees(90.0f)).rotateYDegrees(Mth.m_14179_((float)partialTicks, (float)oldWheel.x(), (float)newWheel.x()))).light(light).renderInto(stack, vcons);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheelBuf.translate(-0.6875, 0.25, 1.15625)).rotateXDegrees(90.0f)).rotateZDegrees(90.0f)).rotateYDegrees(Mth.m_14179_((float)partialTicks, (float)oldWheel.y(), (float)newWheel.y()))).light(light).renderInto(stack, vcons);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheelBuf.translate(0.6875, 0.25, -0.15625)).rotateXDegrees(90.0f)).rotateZDegrees(-90.0f)).rotateYDegrees(Mth.m_14179_((float)partialTicks, (float)oldWheel.z(), (float)newWheel.z()))).light(light).renderInto(stack, vcons);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheelBuf.translate(0.6875, 0.25, 1.15625)).rotateXDegrees(90.0f)).rotateZDegrees(-90.0f)).rotateYDegrees(Mth.m_14179_((float)partialTicks, (float)oldWheel.w(), (float)newWheel.w()))).light(light).renderInto(stack, vcons);
        stack.m_85849_();
        super.m_7392_((Entity)carriage, entityYaw, partialTicks, stack, buffers, light);
    }

    public ResourceLocation getTextureLocation(CannonCarriageEntity entity) {
        return null;
    }
}

