/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class CBCJsonResourceReloadListener
extends SimplePreparableReloadListener<Multimap<ResourceLocation, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;

    public CBCJsonResourceReloadListener(Gson gson, String directory) {
        this.gson = gson;
        this.directory = directory;
    }

    protected Multimap<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMultimap map = HashMultimap.create();
        int i = this.directory.length() + 1;
        for (Map.Entry entry : resourceManager.m_214159_(this.directory, path -> path.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation loco = (ResourceLocation)entry.getKey();
            String string = loco.m_135815_();
            ResourceLocation loc2 = CBCUtils.location(loco.m_135827_(), string.substring(i, string.length() - PATH_SUFFIX_LENGTH));
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                    if (jsonElement != null) {
                        map.put((Object)loc2, (Object)jsonElement);
                        continue;
                    }
                    LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)loc2, (Object)loco);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var20) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{loc2, loco, var20});
            }
        }
        return map;
    }
}

