/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;

public class SerializerVec3f
implements ISerializer<Vector3f> {
    public static final ISerializer<Vector3f> SERIALIZER = new SerializerVec3f();

    @Override
    public Vector3f read(JsonElement json) {
        List<Float> values = Serializers.FLOAT.readList(json);
        if (values.size() == 3) {
            return new Vector3f(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue());
        }
        throw new JsonParseException("Expected 3 elements, had " + values.size() + " instead.");
    }

    @Override
    public JsonElement write(Vector3f toWrite) {
        return Serializers.FLOAT.writeList(new ArrayList<Float>(Arrays.asList(Float.valueOf(toWrite.func_195899_a()), Float.valueOf(toWrite.func_195900_b()), Float.valueOf(toWrite.func_195902_c()))));
    }

    @Override
    public Vector3f read(PacketBuffer buffer) {
        List<Float> values = Serializers.FLOAT.readList(buffer);
        if (values.size() == 3) {
            return new Vector3f(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue());
        }
        throw new IllegalStateException("Expected 3 elements, had " + values.size() + " instead.");
    }

    @Override
    public void write(PacketBuffer buffer, Vector3f toWrite) {
        Serializers.FLOAT.writeList(buffer, new ArrayList<Float>(Arrays.asList(Float.valueOf(toWrite.func_195899_a()), Float.valueOf(toWrite.func_195900_b()), Float.valueOf(toWrite.func_195902_c()))));
    }

    @Override
    public INBT writeNBT(Vector3f toWrite) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74776_a("x", toWrite.func_195899_a());
        tag.func_74776_a("y", toWrite.func_195900_b());
        tag.func_74776_a("z", toWrite.func_195902_c());
        return tag;
    }

    @Override
    public Vector3f read(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            CompoundNBT tag = (CompoundNBT)nbt;
            float x = tag.func_74760_g("x");
            float y = tag.func_74760_g("y");
            float z = tag.func_74760_g("z");
            return new Vector3f(x, y, z);
        }
        throw new IllegalArgumentException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

