/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.network.PacketBuffer;

public final class SerializerInteger
implements ISerializer<Integer> {
    public static final ISerializer<Integer> SERIALIZER = new SerializerInteger();

    private SerializerInteger() {
    }

    @Override
    public Integer read(JsonElement json) {
        return json.getAsInt();
    }

    @Override
    public JsonElement write(Integer toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Integer read(PacketBuffer buffer) {
        return buffer.readInt();
    }

    @Override
    public void write(PacketBuffer buffer, Integer toWrite) {
        buffer.writeInt(toWrite.intValue());
    }

    @Override
    public INBT writeNBT(Integer toWrite) {
        return IntNBT.func_229692_a_((int)toWrite);
    }

    @Override
    public Integer read(INBT nbt) {
        if (nbt instanceof NumberNBT) {
            return ((NumberNBT)nbt).func_150287_d();
        }
        throw new IllegalArgumentException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

