/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.item;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.registries.ForgeRegistries;

public class IngredientToolType
extends Ingredient {
    private final Serializer serializer;
    private final Predicate<ItemStack> stackPred;

    public static Serializer create(Predicate<Item> condition, @Nullable ToolType type) {
        Predicate<Item> itemPred = i -> condition.test((Item)i);
        Predicate<ItemStack> stackPred = s -> !s.func_190926_b() && (itemPred.test(s.func_77973_b()) || type != null && StackUtils.hasToolType(type, s));
        return new Serializer(itemPred, stackPred);
    }

    private IngredientToolType(Predicate<ItemStack> stackPred, Serializer serializer, Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
        this.serializer = serializer;
        this.stackPred = stackPred;
    }

    public boolean test(ItemStack stack) {
        return this.stackPred.test(stack);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<IngredientToolType> getSerializer() {
        return this.serializer;
    }

    static class Serializer
    implements IIngredientSerializer<IngredientToolType> {
        final Predicate<Item> itemPred;
        final Predicate<ItemStack> stackPred;
        private IngredientToolType ingredient;

        private Serializer(Predicate<Item> itemPred, Predicate<ItemStack> stackPred) {
            this.itemPred = itemPred;
            this.stackPred = stackPred;
        }

        public IngredientToolType parse(PacketBuffer buffer) {
            return new IngredientToolType(this.stackPred, this, Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        public IngredientToolType parse(JsonObject json) {
            if (this.ingredient == null) {
                this.ingredient = new IngredientToolType(this.stackPred, this, Stream.of(new StackList(this.getMatchingItems())));
            }
            return this.ingredient;
        }

        public void write(PacketBuffer buffer, IngredientToolType ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }

        private List<ItemStack> getMatchingItems() {
            NonNullList matchingItems = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!this.itemPred.test(item)) continue;
                matchingItems.add(new ItemStack((IItemProvider)item));
            }
            return matchingItems;
        }
    }
}

