/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.kehaannpctrader.network;

import com.lclc98.kehaannpctrader.inventory.container.ShopContainer;
import com.lclc98.kehaannpctrader.json.KHLoader;
import com.lclc98.kehaannpctrader.json.shop.ShopItem;
import java.util.function.Supplier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ShopPurchaseMessage {
    private String shopId;
    private String name;

    public ShopPurchaseMessage() {
    }

    public ShopPurchaseMessage(String name) {
        this.name = name;
    }

    public static void encode(ShopPurchaseMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.name);
    }

    public static ShopPurchaseMessage decode(PacketBuffer buf) {
        String name = buf.func_150789_c(Short.MAX_VALUE);
        return new ShopPurchaseMessage(name);
    }

    public static void handle(ShopPurchaseMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (container instanceof ShopContainer) {
            ShopContainer shopContainer = (ShopContainer)container;
            for (ShopItem item : KHLoader.CONFIG.shopTrades) {
                ItemStack itemstack1;
                if (!item.getId().equals(message.name)) continue;
                ItemStack itemstack = shopContainer.func_75139_a(0).func_75211_c();
                ItemStack itemStack = itemstack1 = item.getCostTwo().func_190926_b() ? ItemStack.field_190927_a : shopContainer.func_75139_a(1).func_75211_c();
                if (!item.take(itemstack, itemstack1) && !item.take(itemstack1, itemstack) || !ShopPurchaseMessage.giveStack((PlayerEntity)player, item.getOutputItemStack())) continue;
                shopContainer.func_75141_a(0, itemstack);
                if (!item.getCostTwo().func_190926_b()) {
                    shopContainer.func_75141_a(1, itemstack1);
                }
                return;
            }
        }
    }

    public static boolean giveStack(PlayerEntity player, ItemStack itemStack) {
        if (player.func_191521_c(itemStack)) {
            return true;
        }
        ItemEntity entityItem = player.func_71019_a(itemStack, false);
        if (entityItem != null) {
            entityItem.func_174868_q();
            entityItem.func_200217_b(player.func_110124_au());
            return true;
        }
        return false;
    }
}

