/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.kehaannpctrader.client.renderer.entity;

import com.lclc98.kehaannpctrader.entity.NPCEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;

public class RendererNPC
extends LivingRenderer<NPCEntity, PlayerModel<NPCEntity>> {
    public RendererNPC(EntityRendererManager renderManager) {
        this(renderManager, false);
    }

    public RendererNPC(EntityRendererManager renderManager, boolean useSmallArms) {
        super(renderManager, (EntityModel)new PlayerModel(0.0f, useSmallArms), 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new SpinAttackEffectLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new BeeStingerLayer((LivingRenderer)this));
    }

    public void render(NPCEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.setModelVisibilities(entityIn);
        super.func_225623_a_((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public Vector3d getRenderOffset(NPCEntity entityIn, float partialTicks) {
        return entityIn.func_213453_ef() ? new Vector3d(0.0, -0.125, 0.0) : super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    private void setModelVisibilities(NPCEntity clientPlayer) {
        PlayerModel model = (PlayerModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            model.func_178719_a(false);
            model.field_78116_c.field_78806_j = true;
            model.field_178720_f.field_78806_j = true;
        } else {
            model.func_178719_a(true);
            model.field_228270_o_ = clientPlayer.func_213453_ef();
            BipedModel.ArmPose bipedmodel$armpose = RendererNPC.getArmPose(clientPlayer, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = RendererNPC.getArmPose(clientPlayer, Hand.OFF_HAND);
            if (bipedmodel$armpose.func_241657_a_()) {
                BipedModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (clientPlayer.func_184591_cq() == HandSide.RIGHT) {
                model.field_187076_m = bipedmodel$armpose;
                model.field_187075_l = bipedmodel$armpose1;
            } else {
                model.field_187076_m = bipedmodel$armpose1;
                model.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    private static BipedModel.ArmPose getArmPose(NPCEntity p_241741_0_, Hand p_241741_1_) {
        ItemStack itemstack = p_241741_0_.func_184586_b(p_241741_1_);
        if (itemstack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (p_241741_0_.func_184600_cs() == p_241741_1_ && p_241741_0_.func_184605_cv() > 0) {
            UseAction useaction = itemstack.func_77975_n();
            if (useaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAction.CROSSBOW && p_241741_1_ == p_241741_0_.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!p_241741_0_.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(NPCEntity entity) {
        return new ResourceLocation("kehaannpctrader", "textures/skins/kehaan.png");
    }

    protected void scale(NPCEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = 0.9375f;
        matrixStackIn.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    protected void renderNameTag(NPCEntity entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        super.func_225629_a_((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    protected void setupRotations(NPCEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - entityLiving.field_70125_A)));
            }
            Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
            Vector3d vector3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

