/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.kehaannpctrader.client.gui.screen;

import com.lclc98.kehaannpctrader.KehaanNPCTrader;
import com.lclc98.kehaannpctrader.json.KHLoader;
import com.lclc98.kehaannpctrader.json.shop.ShopItem;
import com.lclc98.kehaannpctrader.network.ShopSelectMessage;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShopScreen
extends Screen {
    private static final ResourceLocation SHOP_SCREEN_LOCATION = new ResourceLocation("kehaannpctrader", "textures/gui/container/shop.png");
    private static final int ROWS = 3;
    private static final int COLUMNS = 3;
    private final TradeButton[] tradeOfferButtons = new TradeButton[9];
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int SLOT_X = 0;
    private static final int SLOT_Y = 330;
    private static final int SLOT_SIZE = 18;
    private static final int TRADE_ELEMENT_X = 0;
    private static final int TRADE_ELEMENT_Y = 232;
    private static final int TRADE_ELEMENT_WIDTH = 130;
    private static final int TRADE_ELEMENT_HEIGHT = 48;
    private static final int TRADE_ELEMENT_OFFSET_X = 45;
    private static final int PADDING = 6;
    private static final int IMAGE_WIDTH = 438;
    private static final int IMAGE_HEIGHT = 212;
    private int scrollOff;
    private boolean isDragging;
    protected int leftPos;
    protected int topPos;

    public ShopScreen() {
        super(NarratorChatListener.field_216868_a);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.leftPos = (this.field_230708_k_ - 438) / 2;
        this.topPos = (this.field_230709_l_ - 212) / 2;
        int xPos = this.leftPos + 16;
        int yPos = this.topPos + 40;
        for (int l = 0; l < this.tradeOfferButtons.length; ++l) {
            if (l != 0 && l % 3 == 0) {
                xPos = this.leftPos + 16;
                yPos += 54;
            }
            List<ShopItem> shopItemList = this.getItems();
            ShopItem shopItem = null;
            if (shopItemList.size() > l + this.scrollOff) {
                shopItem = shopItemList.get(l + this.scrollOff);
            }
            ShopItem finalShopItem = shopItem;
            this.tradeOfferButtons[l] = (TradeButton)this.func_230480_a_((Widget)new TradeButton(xPos, yPos, l, shopItem, action -> {
                if (action instanceof TradeButton) {
                    KehaanNPCTrader.NETWORK.sendToServer((Object)new ShopSelectMessage(finalShopItem.getId()));
                }
            }));
            xPos += 136;
        }
    }

    protected void renderLabels(MatrixStack matrixStack, int x, int y) {
        String name = "Kehaan Trader";
        this.field_230712_o_.func_238421_b_(matrixStack, name, (float)(219 - this.field_230712_o_.func_78256_a(name) / 2), 6.0f, 0x404040);
    }

    protected void renderBg(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(SHOP_SCREEN_LOCATION);
        int i = (this.field_230708_k_ - 438) / 2;
        int j = (this.field_230709_l_ - 212) / 2;
        ShopScreen.func_238464_a_((MatrixStack)matrixStack, (int)i, (int)j, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)438, (int)212, (int)512, (int)512);
    }

    private void renderScroller(MatrixStack matrixStack, int x, int y, List<ShopItem> shopItems) {
        int i = shopItems.size() + 1 - this.tradeOfferButtons.length;
        if (i > 1) {
            int maxSlide = 141;
            int k = maxSlide / (shopItems.size() / 3 - 2) * this.scrollOff;
            ShopScreen.func_238464_a_((MatrixStack)matrixStack, (int)(x + 422), (int)(y + 34 + k), (int)this.func_230927_p_(), (float)439.0f, (float)0.0f, (int)6, (int)27, (int)512, (int)512);
        } else {
            ShopScreen.func_238464_a_((MatrixStack)matrixStack, (int)(x + 422), (int)(y + 18), (int)this.func_230927_p_(), (float)445.0f, (float)0.0f, (int)6, (int)27, (int)512, (int)512);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.renderBg(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.leftPos, (float)this.topPos, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderLabels(matrixStack, mouseX, mouseY);
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
        if (this.getItems().size() > 0) {
            int i = (this.field_230708_k_ - 438) / 2;
            int j = (this.field_230709_l_ - 212) / 2;
            RenderSystem.pushMatrix();
            RenderSystem.enableRescaleNormal();
            this.field_230706_i_.func_110434_K().func_110577_a(SHOP_SCREEN_LOCATION);
            this.renderScroller(matrixStack, i, j, this.getItems());
            for (TradeButton tradeButton : this.tradeOfferButtons) {
                tradeButton.field_230694_p_ = tradeButton.index < this.getItems().size() && tradeButton.shopItem != null;
            }
            RenderSystem.popMatrix();
        }
    }

    private boolean canScroll(int shopLength) {
        return shopLength > this.tradeOfferButtons.length;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        int i = this.getItems().size();
        if (this.canScroll(i)) {
            int j = (int)Math.ceil((float)(i - this.tradeOfferButtons.length) / 3.0f);
            this.scrollOff = (int)((double)this.scrollOff - delta);
            this.scrollOff = MathHelper.func_76125_a((int)this.scrollOff, (int)0, (int)j);
            this.resetList();
        }
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int i = this.getItems().size();
        if (this.isDragging) {
            int j = this.topPos + 18;
            int k = j + 139;
            int l = i - this.tradeOfferButtons.length;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = MathHelper.func_76125_a((int)((int)f), (int)0, (int)l);
            this.resetList();
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int i = (this.field_230708_k_ - 438) / 2;
        int j = (this.field_230709_l_ - 212) / 2;
        if (this.canScroll(this.getItems().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void resetList() {
        for (TradeButton tradeButton : this.tradeOfferButtons) {
            if (this.getItems().size() > tradeButton.getIndex() + this.scrollOff * 3) {
                ShopItem shopItem = this.getItems().get(tradeButton.getIndex() + this.scrollOff * 3);
                tradeButton.setShopItem(shopItem);
                tradeButton.func_238482_a_((ITextComponent)new StringTextComponent(shopItem.getTitle()));
                continue;
            }
            tradeButton.setShopItem(null);
            tradeButton.func_238482_a_(StringTextComponent.field_240750_d_);
        }
    }

    private List<ShopItem> getItems() {
        return KHLoader.CONFIG.shopTrades;
    }

    @OnlyIn(value=Dist.CLIENT)
    class TradeButton
    extends Button {
        final int index;
        private ShopItem shopItem;

        public TradeButton(int x, int y, int index, ShopItem shopItem, Button.IPressable pressedAction) {
            super(x, y, 130, 48, (ITextComponent)(shopItem == null ? StringTextComponent.field_240750_d_ : new StringTextComponent(shopItem.getTitle())), pressedAction);
            this.index = index;
            this.field_230694_p_ = false;
            this.shopItem = shopItem;
        }

        public int getIndex() {
            return this.index;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            ShopScreen.this.field_230706_i_.func_110434_K().func_110577_a(SHOP_SCREEN_LOCATION);
            this.drawTradeElement(matrixStack, this.func_230449_g_(), this.shopItem);
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }

        public void drawTradeElement(MatrixStack matrixStack, boolean hovered, ShopItem shopItem) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)this.field_230688_j_, (int)this.field_230689_k_, (float)0.0f, (float)(232 + (hovered ? 49 : 0)), (int)130, (int)48, (int)512, (int)512);
            ItemStack costOne = shopItem.getCostOne();
            ItemStack costTwo = shopItem.getCostTwo();
            ItemStack output = shopItem.getOutputItemStack();
            int itemX = (int)((float)this.field_230690_l_ + (float)this.field_230688_j_ * 0.6666667f) - 7;
            int itemY = this.field_230691_m_ + 24;
            if (!costOne.func_190926_b() && !costTwo.func_190926_b()) {
                AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(itemX - 17 - 1), (int)(itemY - 1), (int)18, (int)18, (float)0.0f, (float)330.0f, (int)18, (int)18, (int)512, (int)512);
                AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(itemX + 17 - 1), (int)(itemY - 1), (int)18, (int)18, (float)0.0f, (float)330.0f, (int)18, (int)18, (int)512, (int)512);
                ShopScreen.this.field_230707_j_.func_239390_c_(costOne, itemX - 17, itemY);
                ShopScreen.this.field_230707_j_.func_175030_a(ShopScreen.this.field_230712_o_, costOne, itemX - 17, itemY);
                ShopScreen.this.field_230707_j_.func_239390_c_(costTwo, itemX + 17, itemY);
                ShopScreen.this.field_230707_j_.func_175030_a(ShopScreen.this.field_230712_o_, costTwo, itemX + 17, itemY);
            } else {
                AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(itemX - 1), (int)(itemY - 1), (int)18, (int)18, (float)0.0f, (float)330.0f, (int)18, (int)18, (int)512, (int)512);
                ShopScreen.this.field_230707_j_.func_239390_c_(costOne, itemX, itemY);
                ShopScreen.this.field_230707_j_.func_175030_a(ShopScreen.this.field_230712_o_, costOne, itemX, itemY);
            }
            int outputX = this.field_230690_l_ + 14;
            int outputY = this.field_230691_m_ + 15 + 1;
            ShopScreen.this.field_230707_j_.func_239390_c_(output, outputX, outputY);
            ShopScreen.this.field_230707_j_.func_175030_a(ShopScreen.this.field_230712_o_, output, outputX, outputY);
            TradeButton.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)ShopScreen.this.field_230712_o_, (String)shopItem.getTitle(), (int)(this.field_230690_l_ + 45 + (this.field_230688_j_ - 45) / 2), (int)(this.field_230691_m_ + 7), (int)Color.WHITE.getRGB());
            int lineOffsetX = this.field_230690_l_ + 43;
            int lineOffsetWidth = lineOffsetX + 2;
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)lineOffsetX, (int)this.field_230691_m_, (int)lineOffsetWidth, (int)(this.field_230691_m_ + 48), (int)Color.BLACK.getRGB());
        }

        public void setShopItem(ShopItem shopItem) {
            this.field_230694_p_ = shopItem != null;
            this.shopItem = shopItem;
        }

        public void func_230443_a_(MatrixStack matrixStack, int x, int y) {
            if (this.field_230692_n_ && ShopScreen.this.getItems().size() > this.index + ShopScreen.this.scrollOff) {
                ItemStack costOne = this.shopItem.getCostOne();
                ItemStack costTwo = this.shopItem.getCostTwo();
                ItemStack output = this.shopItem.getOutputItemStack();
                int itemY = this.field_230691_m_ + 27;
                if (y > itemY && y < itemY + 32) {
                    int itemX = (int)((float)this.field_230690_l_ + (float)this.field_230688_j_ * 0.6666667f) - 8;
                    if (!costOne.func_190926_b() && !costTwo.func_190926_b()) {
                        if (x > itemX - 17 && x < itemX - 17 + 16) {
                            ShopScreen.this.func_230457_a_(matrixStack, costOne, x, y);
                        } else if (x > itemX + 17 && x < itemX + 17 + 16) {
                            ShopScreen.this.func_230457_a_(matrixStack, costTwo, x, y);
                        }
                    } else if (x > itemX && x < itemX + 16) {
                        ShopScreen.this.func_230457_a_(matrixStack, costOne, x, y);
                    }
                }
                if (!output.func_190926_b()) {
                    int outputX = this.field_230690_l_ + 14;
                    int outputY = this.field_230691_m_ + this.field_230689_k_ / 2 - 8;
                    if (x > outputX && x < outputX + 16 && y > outputY && y < outputY + 16) {
                        ShopScreen.this.func_230457_a_(matrixStack, output, x, y);
                    }
                }
            }
        }
    }
}

