/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.lighting.LevelBasedGraph;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.SectionLightStorage;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class LightEngine<M extends LightDataMap<M>, S extends SectionLightStorage<M>>
extends LevelBasedGraph
implements IWorldLightListener {
    private static final Direction[] field_215628_d = Direction.values();
    protected final IChunkLightProvider field_215625_a;
    protected final LightType field_215626_b;
    protected final S field_215627_c;
    private boolean field_215629_e;
    protected final BlockPos.Mutable field_215630_f = new BlockPos.Mutable();
    private final long[] field_215631_g = new long[2];
    private final IBlockReader[] field_215632_h = new IBlockReader[2];

    public LightEngine(IChunkLightProvider iChunkLightProvider, LightType lightType, S s) {
        super(16, 256, 8192);
        this.field_215625_a = iChunkLightProvider;
        this.field_215626_b = lightType;
        this.field_215627_c = s;
        this.func_215624_c();
    }

    @Override
    protected void func_215473_f(long l) {
        ((SectionLightStorage)this.field_215627_c).func_215532_c();
        if (((SectionLightStorage)this.field_215627_c).func_215518_g(SectionPos.func_218162_e(l))) {
            super.func_215473_f(l);
        }
    }

    @Nullable
    private IBlockReader func_215615_a(int n3, int n2) {
        int n3;
        long l = ChunkPos.func_77272_a(n3, n2);
        for (int i = 0; i < 2; ++i) {
            if (l != this.field_215631_g[i]) continue;
            return this.field_215632_h[i];
        }
        IBlockReader \u26032 = this.field_215625_a.func_217202_b(n3, n2);
        for (\u2603 = 1; \u2603 > 0; --\u2603) {
            this.field_215631_g[\u2603] = this.field_215631_g[\u2603 - 1];
            this.field_215632_h[\u2603] = this.field_215632_h[\u2603 - 1];
        }
        this.field_215631_g[0] = l;
        this.field_215632_h[0] = \u26032;
        return \u26032;
    }

    private void func_215624_c() {
        Arrays.fill(this.field_215631_g, ChunkPos.field_222244_a);
        Arrays.fill(this.field_215632_h, null);
    }

    protected BlockState func_227468_a_(long l, @Nullable MutableInt mutableInt) {
        if (l == Long.MAX_VALUE) {
            if (mutableInt != null) {
                mutableInt.setValue(0);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        int n = SectionPos.func_218159_a(BlockPos.func_218290_b(l));
        IBlockReader \u26032 = this.func_215615_a(n, \u2603 = SectionPos.func_218159_a(BlockPos.func_218282_d(l)));
        if (\u26032 == null) {
            if (mutableInt != null) {
                mutableInt.setValue(16);
            }
            return Blocks.field_150357_h.func_176223_P();
        }
        this.field_215630_f.func_218294_g(l);
        BlockState \u26033 = \u26032.func_180495_p(this.field_215630_f);
        boolean bl = \u2603 = \u26033.func_200132_m() && \u26033.func_215691_g();
        if (mutableInt != null) {
            mutableInt.setValue(\u26033.func_200016_a(this.field_215625_a.func_212864_k_(), this.field_215630_f));
        }
        return \u2603 ? \u26033 : Blocks.field_150350_a.func_176223_P();
    }

    protected VoxelShape func_223405_a(BlockState blockState, long l, Direction direction) {
        return blockState.func_200132_m() ? blockState.func_215702_a(this.field_215625_a.func_212864_k_(), this.field_215630_f.func_218294_g(l), direction) : VoxelShapes.func_197880_a();
    }

    public static int func_215613_a(IBlockReader iBlockReader, BlockState blockState, BlockPos blockPos, BlockState blockState2, BlockPos blockPos2, Direction direction, int n) {
        boolean bl = blockState.func_200132_m() && blockState.func_215691_g();
        boolean bl2 = \u2603 = blockState2.func_200132_m() && blockState2.func_215691_g();
        if (!bl && !\u2603) {
            return n;
        }
        VoxelShape \u26032 = bl ? blockState.func_235754_c_(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
        VoxelShape voxelShape = \u2603 = \u2603 ? blockState2.func_235754_c_(iBlockReader, blockPos2) : VoxelShapes.func_197880_a();
        if (VoxelShapes.func_204642_b(\u26032, \u2603, direction)) {
            return 16;
        }
        return n;
    }

    @Override
    protected boolean func_215485_a(long l) {
        return l == Long.MAX_VALUE;
    }

    @Override
    protected int func_215477_a(long l, long l2, int n) {
        return 0;
    }

    @Override
    protected int func_215471_c(long l) {
        if (l == Long.MAX_VALUE) {
            return 0;
        }
        return 15 - ((SectionLightStorage)this.field_215627_c).func_215521_h(l);
    }

    protected int func_215622_a(NibbleArray nibbleArray, long l) {
        return 15 - nibbleArray.func_76582_a(SectionPos.func_218171_b(BlockPos.func_218290_b(l)), SectionPos.func_218171_b(BlockPos.func_218274_c(l)), SectionPos.func_218171_b(BlockPos.func_218282_d(l)));
    }

    @Override
    protected void func_215476_a(long l, int n) {
        ((SectionLightStorage)this.field_215627_c).func_215517_b(l, Math.min(15, 15 - n));
    }

    @Override
    protected int func_215480_b(long l, long l2, int n) {
        return 0;
    }

    public boolean func_215619_a() {
        return this.func_215481_b() || ((LevelBasedGraph)this.field_215627_c).func_215481_b() || ((SectionLightStorage)this.field_215627_c).func_215527_a();
    }

    public int func_215616_a(int n2, boolean bl, boolean bl2) {
        int n2;
        if (!this.field_215629_e) {
            if (((LevelBasedGraph)this.field_215627_c).func_215481_b() && (n2 = ((LevelBasedGraph)this.field_215627_c).func_215483_b(n2)) == 0) {
                return n2;
            }
            ((SectionLightStorage)this.field_215627_c).func_215522_a(this, bl, bl2);
        }
        this.field_215629_e = true;
        if (this.func_215481_b()) {
            n2 = this.func_215483_b(n2);
            this.func_215624_c();
            if (n2 == 0) {
                return n2;
            }
        }
        this.field_215629_e = false;
        ((SectionLightStorage)this.field_215627_c).func_215533_d();
        return n2;
    }

    protected void func_215621_a(long l, @Nullable NibbleArray nibbleArray, boolean bl) {
        ((SectionLightStorage)this.field_215627_c).func_215529_a(l, nibbleArray, bl);
    }

    @Override
    @Nullable
    public NibbleArray func_215612_a(SectionPos sectionPos) {
        return ((SectionLightStorage)this.field_215627_c).func_222858_h(sectionPos.func_218146_v());
    }

    @Override
    public int func_215611_b(BlockPos blockPos) {
        return ((SectionLightStorage)this.field_215627_c).func_215525_d(blockPos.func_218275_a());
    }

    public void func_215617_a(BlockPos blockPos) {
        long l = blockPos.func_218275_a();
        this.func_215473_f(l);
        for (Direction direction : field_215628_d) {
            this.func_215473_f(BlockPos.func_218289_a(l, direction));
        }
    }

    public void func_215623_a(BlockPos blockPos, int n) {
    }

    @Override
    public void func_215566_a(SectionPos sectionPos, boolean bl) {
        ((SectionLightStorage)this.field_215627_c).func_215519_c(sectionPos.func_218146_v(), bl);
    }

    public void func_215620_a(ChunkPos chunkPos, boolean bl) {
        long l = SectionPos.func_218169_f(SectionPos.func_218166_b(chunkPos.field_77276_a, 0, chunkPos.field_77275_b));
        ((SectionLightStorage)this.field_215627_c).func_215526_b(l, bl);
    }

    public void func_223129_b(ChunkPos chunkPos, boolean bl) {
        long l = SectionPos.func_218169_f(SectionPos.func_218166_b(chunkPos.field_77276_a, 0, chunkPos.field_77275_b));
        ((SectionLightStorage)this.field_215627_c).func_223113_c(l, bl);
    }
}

