/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FishingBobberEntity
extends ProjectileEntity {
    private final Random field_234596_b_ = new Random();
    private boolean field_234597_c_;
    private int field_234598_d_;
    private static final DataParameter<Integer> field_184528_c = EntityDataManager.func_187226_a(FishingBobberEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_234599_f_ = EntityDataManager.func_187226_a(FishingBobberEntity.class, DataSerializers.field_187198_h);
    private int field_146049_av;
    private int field_146045_ax;
    private int field_146040_ay;
    private int field_146038_az;
    private float field_146054_aA;
    private boolean field_234595_aq_ = true;
    private Entity field_146043_c;
    private State field_190627_av = State.FLYING;
    private final int field_191518_aw;
    private final int field_191519_ax;

    private FishingBobberEntity(World world, PlayerEntity playerEntity, int n, int n2) {
        super((EntityType<? extends ProjectileEntity>)EntityType.field_200730_aI, world);
        this.field_70158_ak = true;
        this.func_212361_a(playerEntity);
        playerEntity.field_71104_cf = this;
        this.field_191518_aw = Math.max(0, n);
        this.field_191519_ax = Math.max(0, n2);
    }

    public FishingBobberEntity(PlayerEntity playerEntity, World world, int n, int n2) {
        this(world, playerEntity, n, n2);
        float f = playerEntity.field_70125_A;
        \u2603 = playerEntity.field_70177_z;
        \u2603 = MathHelper.func_76134_b(-\u2603 * ((float)Math.PI / 180) - (float)Math.PI);
        \u2603 = MathHelper.func_76126_a(-\u2603 * ((float)Math.PI / 180) - (float)Math.PI);
        \u2603 = -MathHelper.func_76134_b(-f * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76126_a(-f * ((float)Math.PI / 180));
        double \u26032 = playerEntity.func_226277_ct_() - (double)\u2603 * 0.3;
        double \u26033 = playerEntity.func_226280_cw_();
        double \u26034 = playerEntity.func_226281_cx_() - (double)\u2603 * 0.3;
        this.func_70012_b(\u26032, \u26033, \u26034, \u2603, f);
        Vector3d \u26035 = new Vector3d(-\u2603, MathHelper.func_76131_a(-(\u2603 / \u2603), -5.0f, 5.0f), -\u2603);
        double \u26036 = \u26035.func_72433_c();
        \u26035 = \u26035.func_216372_d(0.6 / \u26036 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / \u26036 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / \u26036 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(\u26035);
        this.field_70177_z = (float)(MathHelper.func_181159_b(\u26035.field_72450_a, \u26035.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(\u26035.field_72448_b, MathHelper.func_76133_a(FishingBobberEntity.func_213296_b(\u26035))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184528_c, 0);
        this.func_184212_Q().func_187214_a(field_234599_f_, false);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter2) {
        DataParameter<?> dataParameter2;
        if (field_184528_c.equals(dataParameter2)) {
            int n = this.func_184212_Q().func_187225_a(field_184528_c);
            Entity entity = this.field_146043_c = n > 0 ? this.field_70170_p.func_73045_a(n - 1) : null;
        }
        if (field_234599_f_.equals(dataParameter2)) {
            this.field_234597_c_ = this.func_184212_Q().func_187225_a(field_234599_f_);
            if (this.field_234597_c_) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, -0.4f * MathHelper.func_151240_a(this.field_234596_b_, 0.6f, 1.0f), this.func_213322_ci().field_72449_c);
            }
        }
        super.func_184206_a(dataParameter2);
    }

    @Override
    public void func_70071_h_() {
        this.field_234596_b_.setSeed(this.func_110124_au().getLeastSignificantBits() ^ this.field_70170_p.func_82737_E());
        super.func_70071_h_();
        PlayerEntity playerEntity = this.func_234606_i_();
        if (playerEntity == null) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.func_234600_a_(playerEntity)) {
            return;
        }
        if (this.field_70122_E) {
            ++this.field_146049_av;
            if (this.field_146049_av >= 1200) {
                this.func_70106_y();
                return;
            }
        } else {
            this.field_146049_av = 0;
        }
        float \u26032 = 0.0f;
        BlockPos \u26033 = this.func_233580_cy_();
        FluidState \u26034 = this.field_70170_p.func_204610_c(\u26033);
        if (\u26034.func_206884_a(FluidTags.field_206959_a)) {
            \u26032 = \u26034.func_215679_a(this.field_70170_p, \u26033);
        }
        boolean bl = \u2603 = \u26032 > 0.0f;
        if (this.field_190627_av == State.FLYING) {
            if (this.field_146043_c != null) {
                this.func_213317_d(Vector3d.field_186680_a);
                this.field_190627_av = State.HOOKED_IN_ENTITY;
                return;
            }
            if (\u2603) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                this.field_190627_av = State.BOBBING;
                return;
            }
            this.func_190624_r();
        } else {
            if (this.field_190627_av == State.HOOKED_IN_ENTITY) {
                if (this.field_146043_c != null) {
                    if (this.field_146043_c.field_70128_L) {
                        this.field_146043_c = null;
                        this.field_190627_av = State.FLYING;
                    } else {
                        this.func_70107_b(this.field_146043_c.func_226277_ct_(), this.field_146043_c.func_226283_e_(0.8), this.field_146043_c.func_226281_cx_());
                    }
                }
                return;
            }
            if (this.field_190627_av == State.BOBBING) {
                Vector3d vector3d = this.func_213322_ci();
                double \u26035 = this.func_226278_cu_() + vector3d.field_72448_b - (double)\u26033.func_177956_o() - (double)\u26032;
                if (Math.abs(\u26035) < 0.01) {
                    \u26035 += Math.signum(\u26035) * 0.1;
                }
                this.func_213293_j(vector3d.field_72450_a * 0.9, vector3d.field_72448_b - \u26035 * (double)this.field_70146_Z.nextFloat() * 0.2, vector3d.field_72449_c * 0.9);
                this.field_234595_aq_ = this.field_146045_ax > 0 || this.field_146038_az > 0 ? this.field_234595_aq_ && this.field_234598_d_ < 10 && this.func_234603_b_(\u26033) : true;
                if (\u2603) {
                    this.field_234598_d_ = Math.max(0, this.field_234598_d_ - 1);
                    if (this.field_234597_c_) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.1 * (double)this.field_234596_b_.nextFloat() * (double)this.field_234596_b_.nextFloat(), 0.0));
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_190621_a(\u26033);
                    }
                } else {
                    this.field_234598_d_ = Math.min(10, this.field_234598_d_ + 1);
                }
            }
        }
        if (!\u26034.func_206884_a(FluidTags.field_206959_a)) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_234617_x_();
        if (this.field_190627_av == State.FLYING && (this.field_70122_E || this.field_70123_F)) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        double d = 0.92;
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
        this.func_226264_Z_();
    }

    private boolean func_234600_a_(PlayerEntity playerEntity) {
        ItemStack itemStack = playerEntity.func_184614_ca();
        \u2603 = playerEntity.func_184592_cb();
        boolean \u26032 = itemStack.func_77973_b() == Items.field_151112_aM;
        boolean bl = \u2603 = \u2603.func_77973_b() == Items.field_151112_aM;
        if (playerEntity.field_70128_L || !playerEntity.func_70089_S() || !\u26032 && !\u2603 || this.func_70068_e(playerEntity) > 1024.0) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    private void func_190624_r() {
        RayTraceResult rayTraceResult = ProjectileHelper.func_234618_a_(this, this::func_230298_a_);
        this.func_70227_a(rayTraceResult);
    }

    @Override
    protected boolean func_230298_a_(Entity entity) {
        return super.func_230298_a_(entity) || entity.func_70089_S() && entity instanceof ItemEntity;
    }

    @Override
    protected void func_213868_a(EntityRayTraceResult entityRayTraceResult) {
        super.func_213868_a(entityRayTraceResult);
        if (!this.field_70170_p.field_72995_K) {
            this.field_146043_c = entityRayTraceResult.func_216348_a();
            this.func_190622_s();
        }
    }

    @Override
    protected void func_230299_a_(BlockRayTraceResult blockRayTraceResult) {
        super.func_230299_a_(blockRayTraceResult);
        this.func_213317_d(this.func_213322_ci().func_72432_b().func_186678_a(blockRayTraceResult.func_237486_a_(this)));
    }

    private void func_190622_s() {
        this.func_184212_Q().func_187227_b(field_184528_c, this.field_146043_c.func_145782_y() + 1);
    }

    private void func_190621_a(BlockPos blockPos) {
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        int \u26032 = 1;
        BlockPos \u26033 = blockPos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(\u26033)) {
            ++\u26032;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(\u26033)) {
            --\u26032;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
                this.func_184212_Q().func_187227_b(field_234599_f_, false);
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= \u26032;
            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.field_146054_aA * ((float)Math.PI / 180);
                \u2603 = MathHelper.func_76126_a(f);
                \u2603 = MathHelper.func_76134_b(f);
                double \u26034 = this.func_226277_ct_() + (double)(\u2603 * (float)this.field_146038_az * 0.1f);
                BlockState \u26035 = serverWorld.func_180495_p(new BlockPos(\u26034, (\u2603 = (double)((float)MathHelper.func_76128_c(this.func_226278_cu_()) + 1.0f)) - 1.0, \u2603 = this.func_226281_cx_() + (double)(\u2603 * (float)this.field_146038_az * 0.1f)));
                if (\u26035.func_203425_a(Blocks.field_150355_j)) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverWorld.func_195598_a(ParticleTypes.field_197612_e, \u26034, \u2603 - (double)0.1f, \u2603, 1, \u2603, 0.1, \u2603, 0.0);
                    }
                    \u2603 = \u2603 * 0.04f;
                    \u2603 = \u2603 * 0.04f;
                    serverWorld.func_195598_a(ParticleTypes.field_197630_w, \u26034, \u2603, \u2603, 0, \u2603, 0.01, -\u2603, 1.0);
                    serverWorld.func_195598_a(ParticleTypes.field_197630_w, \u26034, \u2603, \u2603, 0, -\u2603, 0.01, \u2603, 1.0);
                }
            } else {
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double \u26036 = this.func_226278_cu_() + 0.5;
                serverWorld.func_195598_a(ParticleTypes.field_197612_e, this.func_226277_ct_(), \u26036, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                serverWorld.func_195598_a(ParticleTypes.field_197630_w, this.func_226277_ct_(), \u26036, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                this.field_146045_ax = MathHelper.func_76136_a(this.field_70146_Z, 20, 40);
                this.func_184212_Q().func_187227_b(field_234599_f_, true);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= \u26032;
            \u2603 = 0.15f;
            if (this.field_146040_ay < 20) {
                \u2603 = (float)((double)\u2603 + (double)(20 - this.field_146040_ay) * 0.05);
            } else if (this.field_146040_ay < 40) {
                \u2603 = (float)((double)\u2603 + (double)(40 - this.field_146040_ay) * 0.02);
            } else if (this.field_146040_ay < 60) {
                \u2603 = (float)((double)\u2603 + (double)(60 - this.field_146040_ay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < \u2603) {
                \u2603 = MathHelper.func_151240_a(this.field_70146_Z, 0.0f, 360.0f) * ((float)Math.PI / 180);
                \u2603 = MathHelper.func_151240_a(this.field_70146_Z, 25.0f, 60.0f);
                double \u26037 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a(\u2603) * \u2603 * 0.1f);
                BlockState \u26038 = serverWorld.func_180495_p(new BlockPos(\u26037, (\u2603 = (double)((float)MathHelper.func_76128_c(this.func_226278_cu_()) + 1.0f)) - 1.0, \u2603 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b(\u2603) * \u2603 * 0.1f)));
                if (\u26038.func_203425_a(Blocks.field_150355_j)) {
                    serverWorld.func_195598_a(ParticleTypes.field_218422_X, \u26037, \u2603, \u2603, 2 + this.field_70146_Z.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a(this.field_70146_Z, 0.0f, 360.0f);
                this.field_146038_az = MathHelper.func_76136_a(this.field_70146_Z, 20, 80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a(this.field_70146_Z, 100, 600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    private boolean func_234603_b_(BlockPos blockPos) {
        WaterType waterType = WaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            WaterType waterType2 = this.func_234602_a_(blockPos.func_177982_a(-2, i, -2), blockPos.func_177982_a(2, i, 2));
            switch (waterType2) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (waterType != WaterType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (waterType != WaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            waterType = waterType2;
        }
        return true;
    }

    private WaterType func_234602_a_(BlockPos blockPos, BlockPos blockPos2) {
        return BlockPos.func_218281_b(blockPos, blockPos2).map(this::func_234604_c_).reduce((waterType, waterType2) -> waterType == waterType2 ? waterType : WaterType.INVALID).orElse(WaterType.INVALID);
    }

    private WaterType func_234604_c_(BlockPos blockPos) {
        BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
        if (blockState.func_196958_f() || blockState.func_203425_a(Blocks.field_196651_dG)) {
            return WaterType.ABOVE_WATER;
        }
        FluidState \u26032 = blockState.func_204520_s();
        if (\u26032.func_206884_a(FluidTags.field_206959_a) && \u26032.func_206889_d() && blockState.func_196952_d(this.field_70170_p, blockPos).func_197766_b()) {
            return WaterType.INSIDE_WATER;
        }
        return WaterType.INVALID;
    }

    public boolean func_234605_g_() {
        return this.field_234595_aq_;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
    }

    public int func_146034_e(ItemStack itemStack) {
        PlayerEntity playerEntity = this.func_234606_i_();
        if (this.field_70170_p.field_72995_K || playerEntity == null) {
            return 0;
        }
        int \u26032 = 0;
        if (this.field_146043_c != null) {
            this.func_184527_k();
            CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)playerEntity, itemStack, this, Collections.emptyList());
            this.field_70170_p.func_72960_a(this, (byte)31);
            \u26032 = this.field_146043_c instanceof ItemEntity ? 3 : 5;
        } else if (this.field_146045_ax > 0) {
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, itemStack).func_216015_a(LootParameters.field_216281_a, this).func_216023_a(this.field_70146_Z).func_186469_a((float)this.field_191518_aw + playerEntity.func_184817_da());
            LootTable \u26033 = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
            List<ItemStack> \u26034 = \u26033.func_216113_a(builder.func_216022_a(LootParameterSets.field_216262_c));
            CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)playerEntity, itemStack, this, \u26034);
            for (ItemStack itemStack2 : \u26034) {
                ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemStack2);
                double \u26035 = playerEntity.func_226277_ct_() - this.func_226277_ct_();
                double \u26036 = playerEntity.func_226278_cu_() - this.func_226278_cu_();
                double \u26037 = playerEntity.func_226281_cx_() - this.func_226281_cx_();
                double \u26038 = 0.1;
                itemEntity.func_213293_j(\u26035 * 0.1, \u26036 * 0.1 + Math.sqrt(Math.sqrt(\u26035 * \u26035 + \u26036 * \u26036 + \u26037 * \u26037)) * 0.08, \u26037 * 0.1);
                this.field_70170_p.func_217376_c(itemEntity);
                playerEntity.field_70170_p.func_217376_c(new ExperienceOrbEntity(playerEntity.field_70170_p, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_() + 0.5, playerEntity.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                if (!itemStack2.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                playerEntity.func_195067_a(Stats.field_188071_E, 1);
            }
            \u26032 = 1;
        }
        if (this.field_70122_E) {
            \u26032 = 2;
        }
        this.func_70106_y();
        return \u26032;
    }

    protected void func_184527_k() {
        Entity entity = this.func_234616_v_();
        if (entity == null) {
            return;
        }
        Vector3d \u26032 = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
        this.field_146043_c.func_213317_d(this.field_146043_c.func_213322_ci().func_178787_e(\u26032));
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        PlayerEntity playerEntity = this.func_234606_i_();
        if (playerEntity != null) {
            playerEntity.field_71104_cf = null;
        }
    }

    @Nullable
    public PlayerEntity func_234606_i_() {
        Entity entity = this.func_234616_v_();
        return entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
    }

    @Nullable
    public Entity func_234607_k_() {
        return this.field_146043_c;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        Entity entity = this.func_234616_v_();
        return new SSpawnObjectPacket(this, entity == null ? this.func_145782_y() : entity.func_145782_y());
    }

    static enum WaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

