/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.GroundPathHelper;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;

public class VindicatorEntity
extends AbstractIllagerEntity {
    private static final Predicate<Difficulty> field_213681_b = difficulty -> difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD;
    private boolean field_190643_b;

    public VindicatorEntity(EntityType<? extends VindicatorEntity> entityType, World world) {
        super((EntityType<? extends AbstractIllagerEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new BreakDoorGoal(this));
        this.field_70714_bg.func_75776_a(2, new AbstractIllagerEntity.RaidOpenDoorGoal(this));
        this.field_70714_bg.func_75776_a(3, new AbstractRaiderEntity.FindTargetGoal(this, this, 10.0f));
        this.field_70714_bg.func_75776_a(4, new AttackGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(4, new JohnnyAttackGoal(this));
        this.field_70714_bg.func_75776_a(8, new RandomWalkingGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 8.0f));
    }

    @Override
    protected void func_70619_bc() {
        if (!this.func_175446_cd() && GroundPathHelper.func_242319_a(this)) {
            boolean bl = ((ServerWorld)this.field_70170_p).func_217455_d_(this.func_233580_cy_());
            ((GroundPathNavigator)this.func_70661_as()).func_179688_b(bl);
        }
        super.func_70619_bc();
    }

    public static AttributeModifierMap.MutableAttribute func_234322_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.35f).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.field_190643_b) {
            compoundNBT.func_74757_a("Johnny", true);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("Johnny", 99)) {
            this.field_190643_b = compoundNBT.func_74767_n("Johnny");
        }
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219707_mP;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        return iLivingEntityData2;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (this.func_213663_ek() == null) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151036_c));
        }
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    public void func_200203_b(@Nullable ITextComponent iTextComponent) {
        super.func_200203_b(iTextComponent);
        if (!this.field_190643_b && iTextComponent != null && iTextComponent.getString().equals("Johnny")) {
            this.field_190643_b = true;
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191270_ho;
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
        ItemStack itemStack = new ItemStack(Items.field_151036_c);
        Raid \u26032 = this.func_213663_ek();
        int \u26033 = 1;
        if (n > \u26032.func_221306_a(Difficulty.NORMAL)) {
            \u26033 = 2;
        }
        boolean bl2 = \u2603 = this.field_70146_Z.nextFloat() <= \u26032.func_221308_w();
        if (\u2603) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.field_185302_k, \u26033);
            EnchantmentHelper.func_82782_a(hashMap, itemStack);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
    }

    static class JohnnyAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public JohnnyAttackGoal(VindicatorEntity vindicatorEntity) {
            super(vindicatorEntity, LivingEntity.class, 0, true, true, LivingEntity::func_190631_cK);
        }

        @Override
        public boolean func_75250_a() {
            return ((VindicatorEntity)this.field_75299_d).field_190643_b && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_75299_d.func_213332_m(0);
        }
    }

    static class BreakDoorGoal
    extends net.minecraft.entity.ai.goal.BreakDoorGoal {
        public BreakDoorGoal(MobEntity mobEntity) {
            super(mobEntity, 6, field_213681_b);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75253_b() {
            VindicatorEntity vindicatorEntity = (VindicatorEntity)this.field_75356_a;
            return vindicatorEntity.func_213657_el() && super.func_75253_b();
        }

        @Override
        public boolean func_75250_a() {
            VindicatorEntity vindicatorEntity = (VindicatorEntity)this.field_75356_a;
            return vindicatorEntity.func_213657_el() && vindicatorEntity.field_70146_Z.nextInt(10) == 0 && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_75356_a.func_213332_m(0);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(VindicatorEntity vindicatorEntity2) {
            super(vindicatorEntity2, 1.0, false);
        }

        @Override
        protected double func_179512_a(LivingEntity livingEntity2) {
            LivingEntity livingEntity2;
            if (this.field_75441_b.func_184187_bx() instanceof RavagerEntity) {
                float f = this.field_75441_b.func_184187_bx().func_213311_cf() - 0.1f;
                return f * 2.0f * (f * 2.0f) + livingEntity2.func_213311_cf();
            }
            return super.func_179512_a(livingEntity2);
        }
    }
}

