/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.advancements;

import betteradvancements.BetterAdvancements;
import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.util.FolderUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class BetterDisplayInfoRegistry {
    private Map<ResourceLocation, BetterDisplayInfo> registry = new HashMap<ResourceLocation, BetterDisplayInfo>();

    public BetterDisplayInfoRegistry(Advancement advancement) {
    }

    public BetterDisplayInfo get(Advancement advancement) {
        return this.registry.getOrDefault(advancement.func_192067_g(), new BetterDisplayInfo(advancement));
    }

    private void load(ResourceLocation location, ServerWorld world) {
        JsonParser parser = new JsonParser();
        FolderUtil.findAdvancements(location, world, null, (root, file) -> {
            String relative;
            try {
                relative = root.relativize((Path)file).toString();
            }
            catch (Exception e) {
                relative = "";
            }
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(location.func_110624_b(), name);
            if (!this.registry.containsKey(key)) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(file);
                    JsonObject advancement = parser.parse((Reader)reader).getAsJsonObject();
                    JsonObject betterDisplay = advancement.getAsJsonObject("better_display");
                    this.registry.put(key, new BetterDisplayInfo(key, betterDisplay));
                }
                catch (JsonParseException jsonparseexception) {
                    BetterAdvancements.log.error("Parsing error loading built-in advancement " + key, (Throwable)jsonparseexception);
                    Boolean bl = false;
                    return bl;
                }
                catch (IOException ioexception) {
                    BetterAdvancements.log.error("Couldn't read advancement " + key + " from " + file, (Throwable)ioexception);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, true, true);
    }
}

