/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;

public abstract class PropertyIndexer<T extends Comparable<T>> {
    private static final Map<Property<?>, PropertyIndexer<?>> KNOWN_INDEXERS = new Object2ObjectOpenCustomHashMap(Util.func_212443_g());
    private final Property<T> property;
    private final int numValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>> PropertyIndexer<T> makeIndexer(Property<T> prop) {
        Map<Property<?>, PropertyIndexer<?>> map = KNOWN_INDEXERS;
        synchronized (map) {
            PropertyIndexer unchecked = KNOWN_INDEXERS.computeIfAbsent(prop, propInner -> {
                PropertyIndexer result = null;
                if (propInner instanceof BooleanProperty) {
                    result = new BoolIndexer((BooleanProperty)propInner);
                } else if (propInner instanceof IntegerProperty) {
                    result = new IntIndexer((IntegerProperty)propInner);
                } else if (WeirdVanillaDirectionIndexer.isApplicable(propInner)) {
                    result = new WeirdVanillaDirectionIndexer((Property<Direction>)propInner);
                } else if (propInner instanceof EnumProperty) {
                    result = new EnumIndexer((EnumProperty)propInner);
                }
                if (result == null || !result.isValid()) {
                    return new GenericIndexer(propInner);
                }
                return result;
            });
            return unchecked;
        }
    }

    protected PropertyIndexer(Property<T> property) {
        this.property = property;
        this.numValues = property.func_177700_c().size();
    }

    public Property<T> getProperty() {
        return this.property;
    }

    public int numValues() {
        return this.numValues;
    }

    @Nullable
    public abstract T byIndex(int var1);

    public abstract int toIndex(T var1);

    protected boolean isValid() {
        Collection allowed = this.getProperty().func_177700_c();
        int index = 0;
        for (Comparable val : allowed) {
            if (this.toIndex(val) != index || !val.equals(this.byIndex(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static class BoolIndexer
    extends PropertyIndexer<Boolean> {
        protected BoolIndexer(BooleanProperty property) {
            super(property);
        }

        @Override
        @Nullable
        public Boolean byIndex(int index) {
            switch (index) {
                case 0: {
                    return Boolean.TRUE;
                }
                case 1: {
                    return Boolean.FALSE;
                }
            }
            return null;
        }

        @Override
        public int toIndex(Boolean value) {
            return value != false ? 0 : 1;
        }
    }

    private static class IntIndexer
    extends PropertyIndexer<Integer> {
        private final int min;

        protected IntIndexer(IntegerProperty property) {
            super(property);
            this.min = property.func_177700_c().stream().min(Comparator.naturalOrder()).orElse(0);
        }

        @Override
        @Nullable
        public Integer byIndex(int index) {
            if (index >= 0 && index < this.numValues()) {
                return index + this.min;
            }
            return null;
        }

        @Override
        public int toIndex(Integer value) {
            return value - this.min;
        }
    }

    private static class WeirdVanillaDirectionIndexer
    extends PropertyIndexer<Direction> {
        private static final Direction[] ORDER = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};

        public WeirdVanillaDirectionIndexer(Property<Direction> prop) {
            super(prop);
            Preconditions.checkState((boolean)this.isValid());
        }

        static boolean isApplicable(Property<?> prop) {
            Collection values = prop.func_177700_c();
            if (values.size() != ORDER.length) {
                return false;
            }
            return Arrays.equals(ORDER, values.toArray());
        }

        @Override
        @Nullable
        public Direction byIndex(int index) {
            if (index >= 0 && index < ORDER.length) {
                return ORDER[index];
            }
            return null;
        }

        @Override
        public int toIndex(Direction value) {
            switch (value) {
                case NORTH: {
                    return 0;
                }
                case EAST: {
                    return 1;
                }
                case SOUTH: {
                    return 2;
                }
                case WEST: {
                    return 3;
                }
                case UP: {
                    return 4;
                }
                case DOWN: {
                    return 5;
                }
            }
            return -1;
        }
    }

    private static class EnumIndexer<E extends Enum<E>>
    extends PropertyIndexer<E> {
        private final int ordinalOffset;
        private final E[] enumValues;

        protected EnumIndexer(EnumProperty<E> property) {
            super(property);
            this.ordinalOffset = property.func_177700_c().stream().mapToInt(rec$ -> ((Enum)rec$).ordinal()).min().orElse(0);
            this.enumValues = (Enum[])this.getProperty().func_177699_b().getEnumConstants();
        }

        @Override
        @Nullable
        public E byIndex(int index) {
            int arrayIndex = index + this.ordinalOffset;
            if (arrayIndex < this.enumValues.length) {
                return this.enumValues[arrayIndex];
            }
            return null;
        }

        @Override
        public int toIndex(E value) {
            return ((Enum)value).ordinal() - this.ordinalOffset;
        }
    }

    private static class GenericIndexer<T extends Comparable<T>>
    extends PropertyIndexer<T> {
        private final Map<Comparable<?>, Integer> toValueIndex;
        private final List<T> values;

        protected GenericIndexer(Property<T> property) {
            super(property);
            this.values = ImmutableList.copyOf((Collection)property.func_177700_c());
            ImmutableMap.Builder toValueIndex = ImmutableMap.builder();
            for (int i = 0; i < this.values.size(); ++i) {
                toValueIndex.put((Object)((Comparable)this.values.get(i)), (Object)i);
            }
            this.toValueIndex = toValueIndex.build();
        }

        @Override
        @Nullable
        public T byIndex(int index) {
            return (T)((Comparable)this.values.get(index));
        }

        @Override
        public int toIndex(T value) {
            return this.toValueIndex.getOrDefault(value, -1);
        }
    }
}

