/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallTunnel
extends MineshaftPiece {
    private final List<Integer> supports = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 8;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 7;

    public SmallTunnel(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL, compoundTag);
        ListNBT listTag1 = compoundTag.func_150295_c("Supports", 3);
        for (int i = 0; i < listTag1.size(); ++i) {
            this.supports.add(listTag1.func_186858_c(i));
        }
    }

    public SmallTunnel(int chainLength, Random random, MutableBoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL, chainLength, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
        ListNBT listTag1 = new ListNBT();
        this.supports.forEach(z -> listTag1.add((Object)IntNBT.func_229692_a_((int)z)));
        tag.func_218657_a("Supports", (INBT)listTag1);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)8, (Direction)direction);
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, direction, this.chainLength);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, direction, this.chainLength);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, direction, this.chainLength);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, direction, this.chainLength);
            }
        }
        this.buildSupports(random);
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 7)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 4, 7, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 7, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 3, 3, 7, field_202556_l);
        this.replaceAir(world, box, 1, 0, 0, 3, 0, 7, this.getMainBlock());
        this.generateSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateCobwebs(world, box, random);
        this.generateChestCarts(world, box, random, LootTables.field_186424_f);
        this.generateTntCarts(world, box, random);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 3, 7);
        this.addVines(world, box, random, this.settings.vineChance, 1, 0, 1, 3, 4, 6);
        this.generateTorches(world, box, random);
        return true;
    }

    private void generateCobwebs(ISeedReader world, MutableBoundingBox box, Random random) {
        float chance = ((Double)Configuration.spawnRates.cobwebSpawnRate.get()).floatValue();
        this.supports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, chance, 1, 3, z - 3, 1, 3, z + 3, Blocks.field_196553_aF.func_176223_P());
            this.chanceReplaceAir(world, box, random, chance, 3, 3, z - 3, 3, 3, z + 3, Blocks.field_196553_aF.func_176223_P());
        });
    }

    private void generateChestCarts(ISeedReader world, MutableBoundingBox box, Random random, ResourceLocation lootTableId) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos blockPos;
            if (!((double)random.nextFloat() < (Double)Configuration.spawnRates.smallShaftChestMinecartSpawnRate.get()) || !box.func_175898_b((Vector3i)(blockPos = new BlockPos(this.func_74865_a(2, z), this.func_74862_a(1), this.func_74873_b(2, z)))) || world.func_180495_p(blockPos.func_177977_b()).func_196958_f()) continue;
            ChestMinecartEntity chestMinecartEntity = new ChestMinecartEntity((World)world.func_201672_e(), (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            chestMinecartEntity.func_184289_a(lootTableId, random.nextLong());
            world.func_217376_c((Entity)chestMinecartEntity);
        }
    }

    private void generateSupports(ISeedReader world, MutableBoundingBox box, Random random) {
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof WallBlock) {
            supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((Property)WallBlock.field_235612_b_, (Comparable)WallHeight.TALL)).func_206870_a((Property)WallBlock.field_235615_e_, (Comparable)WallHeight.TALL);
        } else if (supportBlock.func_177230_c() instanceof FourWayBlock) {
            supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.supports) {
            this.fill(world, box, 1, 1, z, 1, 2, z, this.getSupportBlock());
            this.fill(world, box, 3, 1, z, 3, 2, z, this.getSupportBlock());
            this.fill(world, box, 1, 3, z, 3, 3, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.25f, 1, 3, z, 3, 3, z, supportBlock);
        }
    }

    private void generateRails(ISeedReader world, MutableBoundingBox box, Random random) {
        this.chanceFill(world, box, random, 0.5f, 2, 1, 0, 2, 1, 7, Blocks.field_150448_aq.func_176223_P());
        for (int n = 0; n <= 7; ++n) {
            this.chanceAddBlock(world, random, 0.07f, (BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(true)), 2, 1, n, box);
        }
    }

    private void generateTntCarts(ISeedReader world, MutableBoundingBox box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos blockPos;
            if (!((double)random.nextFloat() < (Double)Configuration.spawnRates.smallShaftTntMinecartSpawnRate.get()) || !box.func_175898_b((Vector3i)(blockPos = new BlockPos(this.func_74865_a(2, z), this.func_74862_a(1), this.func_74873_b(2, z)))) || world.func_180495_p(blockPos.func_177977_b()).func_196958_f()) continue;
            TNTMinecartEntity tntMinecartEntity = new TNTMinecartEntity((World)world.func_201672_e(), (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            world.func_217376_c((Entity)tntMinecartEntity);
        }
    }

    private void generateTorches(ISeedReader world, MutableBoundingBox box, Random random) {
        BlockState torchBlock = Blocks.field_196591_bQ.func_176223_P();
        for (int z = 0; z <= 7; ++z) {
            boolean canPlace;
            BlockPos adjPos;
            BlockPos pos;
            if (this.supports.contains(z)) continue;
            float r = random.nextFloat();
            if ((double)r < (Double)Configuration.spawnRates.torchSpawnRate.get() / 2.0) {
                pos = new BlockPos(this.func_74865_a(1, z), this.func_74862_a(2), this.func_74873_b(1, z));
                adjPos = new BlockPos(this.func_74865_a(0, z), this.func_74862_a(2), this.func_74873_b(0, z));
                boolean bl = canPlace = world.func_180495_p(pos).func_196958_f() && world.func_180495_p(adjPos) != field_202556_l;
                if (!canPlace) continue;
                this.replaceAir(world, box, 1, 2, z, 1, 2, z, (BlockState)torchBlock.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST));
                continue;
            }
            if (!((double)r < (Double)Configuration.spawnRates.torchSpawnRate.get())) continue;
            pos = new BlockPos(this.func_74865_a(3, z), this.func_74862_a(2), this.func_74873_b(3, z));
            adjPos = new BlockPos(this.func_74865_a(4, z), this.func_74862_a(2), this.func_74873_b(4, z));
            boolean bl = canPlace = world.func_180495_p(pos).func_196958_f() && world.func_180495_p(adjPos) != field_202556_l;
            if (!canPlace) continue;
            this.replaceAir(world, box, 3, 2, z, 3, 2, z, (BlockState)torchBlock.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST));
        }
    }

    private void buildSupports(Random random) {
        for (int z = 0; z <= 7; ++z) {
            int r = random.nextInt(7);
            if (r != 0) continue;
            this.supports.add(z);
            z += 5;
        }
    }
}

