/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class UnsortedRemappingMethodAdapter
extends MethodRemapper {
    private static final Collection<Handle> META_FACTORIES = Arrays.asList(new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false));
    protected final CustomRemapper remapper;
    private final ClassRepo classRepo;

    public UnsortedRemappingMethodAdapter(MethodVisitor mv, CustomRemapper remapper, ClassRepo classRepo) {
        super(mv, (Remapper)remapper);
        Preconditions.checkArgument((mv != null ? 1 : 0) != 0, (Object)"mv");
        this.remapper = remapper;
        this.classRepo = classRepo;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.mv.visitFieldInsn(opcode, this.remapper.mapType(owner), this.remapper.mapFieldName(owner, name, desc, this.findAccess(NodeType.FIELD, owner, name, desc)), this.remapper.mapDesc(desc));
    }

    private int findAccess(NodeType type, String owner, String name, String desc, ClassRepo repo) {
        ClassNode clazz;
        int access = -1;
        if (repo != null && (clazz = this.classRepo.findClass(owner)) != null) {
            block0 : switch (type) {
                case FIELD: {
                    for (FieldNode f : clazz.fields) {
                        if (!f.name.equals(name) || !f.desc.equals(desc)) continue;
                        access = f.access;
                        break block0;
                    }
                    break;
                }
                case METHOD: {
                    for (MethodNode m : this.classRepo.findClass((String)owner).methods) {
                        if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
                        access = m.access;
                        break block0;
                    }
                    break;
                }
            }
        }
        return access;
    }

    public int findAccess(NodeType type, String owner, String name, String desc) {
        int access = this.findAccess(type, owner, name, desc, this.classRepo);
        if (access == -1) {
            access = this.findAccess(type, owner, name, desc, RuntimeRepo.getInstance());
        }
        return access;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.mv.visitMethodInsn(opcode, this.remapper.mapType(owner), this.remapper.mapMethodName(owner, name, desc, this.findAccess(NodeType.METHOD, owner, name, desc)), this.remapper.mapMethodDesc(desc), itf);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (META_FACTORIES.contains(bsm)) {
            String owner = Type.getReturnType((String)desc).getInternalName();
            String odesc = ((Type)bsmArgs[0]).getDescriptor();
            name = this.remapper.mapMethodName(owner, name, odesc, this.findAccess(NodeType.METHOD, owner, name, odesc));
        } else {
            name = this.remapper.mapInvokeDynamicMethodName(name, desc);
        }
        for (int i = 0; i < bsmArgs.length; ++i) {
            bsmArgs[i] = this.remapper.mapValue(bsmArgs[i]);
        }
        this.mv.visitInvokeDynamicInsn(name, this.remapper.mapMethodDesc(desc), (Handle)this.remapper.mapValue(bsm), bsmArgs);
    }
}

