/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.item.IAugmentItem;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class AugmentDataHelper {
    private AugmentDataHelper() {
    }

    public static boolean isAugmentItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IAugmentItem;
    }

    public static boolean hasAugmentData(ItemStack stack) {
        return AugmentDataHelper.getAugmentData(stack) != null;
    }

    @Nullable
    public static CompoundNBT getAugmentData(ItemStack augment) {
        CompoundNBT augmentData = augment.func_179543_a("AugmentData");
        if (augmentData == null && AugmentDataHelper.isAugmentItem(augment)) {
            return ((IAugmentItem)augment.func_77973_b()).getAugmentData(augment);
        }
        return augmentData;
    }

    public static String getAugmentType(ItemStack augment) {
        CompoundNBT augmentTag = AugmentDataHelper.getAugmentData(augment);
        return augmentTag != null ? augmentTag.func_74779_i("Type") : "";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        CompoundNBT augmentData = new CompoundNBT();

        public CompoundNBT build() {
            return this.augmentData.isEmpty() ? null : this.augmentData;
        }

        public Builder type(String type) {
            this.augmentData.func_74778_a("Type", type);
            return this;
        }

        public Builder mod(String mod, float value) {
            this.augmentData.func_74776_a(mod, value);
            return this;
        }

        public Builder feature(String mod, String value) {
            this.augmentData.func_74778_a(mod, value);
            return this;
        }
    }
}

