/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item.impl;

import cofh.lib.entity.KnifeEntity;
import cofh.lib.item.impl.SwordItemCoFH;
import cofh.lib.util.constants.ToolTypes;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class KnifeItem
extends SwordItemCoFH {
    private static final int DEFAULT_ATTACK_DAMAGE = 1;
    private static final float DEFAULT_ATTACK_SPEED = -2.0f;
    private static final ProjectileDispenseBehavior DISPENSER_BEHAVIOR = new ProjectileDispenseBehavior(){

        protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
            KnifeEntity knife = new KnifeEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stackIn);
            knife.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            return knife;
        }

        protected float func_82498_a() {
            return 3.0f;
        }
    };

    public KnifeItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public KnifeItem(IItemTier tier, Item.Properties builder) {
        this(tier, 1, -2.0f, builder.addToolType(ToolTypes.KNIFE, tier.func_200925_d()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.equals(Enchantments.field_203193_C);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int durationRemaining) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            float power = BowItem.func_185059_b((int)(this.func_77626_a(stack) - durationRemaining));
            if ((double)power < 0.1) {
                return;
            }
            if (!world.field_72995_K) {
                KnifeEntity knifeEntity = new KnifeEntity(world, (LivingEntity)player, stack);
                knifeEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, power * 3.0f, 0.1f);
                if (player.field_71075_bZ.field_75098_d) {
                    knifeEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                world.func_217376_c((Entity)knifeEntity);
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_184437_d(stack);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }
}

