/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.enchantment;

import cofh.lib.capability.CapabilityEnchantableItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public abstract class EnchantmentCoFH
extends Enchantment {
    protected boolean enable = true;
    protected boolean allowGenerateInLoot = true;
    protected boolean allowOnBooks = true;
    protected boolean allowVillagerTrade = true;
    protected boolean treasureEnchantment = false;
    protected int maxLevel = 1;

    protected EnchantmentCoFH(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType[] slots) {
        super(rarityIn, typeIn, slots);
    }

    public EnchantmentCoFH setEnable(boolean enable) {
        this.enable = enable;
        this.field_77350_z = enable ? this.func_77320_a() : "enchantment.cofh_core.disabled";
        return this;
    }

    public EnchantmentCoFH setTreasureEnchantment(boolean treasureEnchantment) {
        this.treasureEnchantment = treasureEnchantment;
        return this;
    }

    public EnchantmentCoFH setAllowOnBooks(boolean allowOnBooks) {
        this.allowOnBooks = allowOnBooks;
        return this;
    }

    public EnchantmentCoFH setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
        return this;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    protected boolean supportsEnchantment(ItemStack stack) {
        return stack.getCapability(CapabilityEnchantableItem.ENCHANTABLE_ITEM_CAPABILITY).filter(cap -> cap.supportsEnchantment(this)).isPresent();
    }

    public int func_223551_b(int level) {
        return this.enable ? this.maxDelegate(level) : -1;
    }

    protected int maxDelegate(int level) {
        return this.func_77321_a(level) + 5;
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.enable && (super.canApplyAtEnchantingTable(stack) || this.supportsEnchantment(stack));
    }

    public boolean isAllowedOnBooks() {
        return this.enable && this.allowOnBooks;
    }

    public boolean func_230310_i_() {
        return this.enable && this.allowGenerateInLoot;
    }

    public boolean func_230309_h_() {
        return this.enable && this.allowVillagerTrade;
    }

    public boolean func_185261_e() {
        return this.treasureEnchantment;
    }
}

