/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class ItemModeChangePacket
extends PacketBase
implements IPacketServer {
    protected boolean decr;

    public ItemModeChangePacket() {
        super(64, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        if (!ItemHelper.isPlayerHoldingMultiModeItem((PlayerEntity)player)) {
            return;
        }
        if (this.decr && ItemHelper.decrHeldMultiModeItemState((PlayerEntity)player) || ItemHelper.incrHeldMultiModeItemState((PlayerEntity)player)) {
            ItemHelper.onHeldMultiModeItemChange((PlayerEntity)player);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeBoolean(this.decr);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.decr = buf.readBoolean();
    }

    public static void incrMode() {
        ItemModeChangePacket.sendToServer(false);
    }

    public static void decrMode() {
        ItemModeChangePacket.sendToServer(true);
    }

    private static void sendToServer(boolean decr) {
        ItemModeChangePacket packet = new ItemModeChangePacket();
        packet.decr = decr;
        packet.sendToServer();
    }
}

