/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.inventory.IInventoryContainerItem;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class InventoryContainerItem
extends ItemCoFH
implements IInventoryContainerItem {
    protected static final int MAP_CAPACITY = 128;
    protected static final WeakHashMap<ItemStack, SimpleItemInv> INVENTORIES = new WeakHashMap(128);
    protected int slots;

    public InventoryContainerItem(Item.Properties builder, int slots) {
        super(builder);
        this.slots = slots;
    }

    protected SimpleItemInv readInventoryFromNBT(ItemStack container) {
        CompoundNBT containerTag = this.getOrCreateInvTag(container);
        int numSlots = this.getContainerSlots(container);
        ArrayList<ItemStorageCoFH> invSlots = new ArrayList<ItemStorageCoFH>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            invSlots.add(new ItemStorageCoFH());
        }
        SimpleItemInv inventory = new SimpleItemInv(invSlots);
        inventory.read(containerTag);
        return inventory;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "ItemInv");
    }

    @Override
    public SimpleItemInv getContainerInventory(ItemStack container) {
        SimpleItemInv ret = INVENTORIES.get(container);
        if (ret != null) {
            return ret;
        }
        if (INVENTORIES.size() > 128) {
            INVENTORIES.clear();
        }
        INVENTORIES.put(container, this.readInventoryFromNBT(container));
        return INVENTORIES.get(container);
    }

    @Override
    public int getContainerSlots(ItemStack container) {
        return this.slots;
    }

    @Override
    public void onContainerInventoryChanged(ItemStack container) {
        INVENTORIES.remove(container);
    }
}

