/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreConfig;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.XpHelper;
import cofh.lib.util.references.CoreReferences;
import java.util.Map;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class CoreCommonEvents {
    private CoreCommonEvents() {
    }

    @SubscribeEvent
    public static void handleFarmlandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
        int encFeatherFalling;
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.improvedFeatherFalling) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (encFeatherFalling = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, Enchantments.field_180309_e)) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleLivingFallEvent(LivingFallEvent event) {
        LivingEntity living;
        if (event.isCanceled()) {
            return;
        }
        if ((double)event.getDistance() >= 3.0 && (living = event.getEntityLiving()).func_70644_a(CoreReferences.SLIMED)) {
            Vector3d motion = living.func_213322_ci();
            living.func_213293_j(motion.field_72450_a, 0.08 * Math.sqrt((double)event.getDistance() / 0.08), motion.field_72449_c);
            living.field_70133_I = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleItemFishedEvent(ItemFishedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.enableFishingExhaustion) {
            return;
        }
        Entity player = event.getHookEntity().func_234616_v_();
        if (!(player instanceof PlayerEntity) || player instanceof FakePlayer) {
            return;
        }
        ((PlayerEntity)player).func_71020_j(CoreConfig.amountFishingExhaustion);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        ItemStack itemstack;
        Map.Entry<EquipmentSlotType, ItemStack> entry;
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ExperienceOrbEntity orb = event.getOrb();
        player.field_71090_bL = 2;
        player.func_71001_a((Entity)orb, 1);
        if (CoreConfig.improvedMending && (entry = CoreCommonEvents.getMostDamagedItem(player)) != null && !(itemstack = entry.getValue()).func_190926_b() && itemstack.func_77951_h()) {
            int i = Math.min((int)((float)orb.field_70530_e * itemstack.getXpRepairRatio()), itemstack.func_77952_i());
            orb.field_70530_e -= CoreCommonEvents.durabilityToXp(i);
            itemstack.func_196085_b(itemstack.func_77952_i() - i);
        }
        XpHelper.attemptStoreXP(player, orb);
        if (orb.field_70530_e > 0) {
            player.func_195068_e(orb.field_70530_e);
        }
        orb.func_70106_y();
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.enableSaplingGrowthMod) {
            return;
        }
        if (event.getRand().nextInt(CoreConfig.amountSaplingGrowthMod) != 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Utils.tickTimeConstants();
        }
    }

    private static Map.Entry<EquipmentSlotType, ItemStack> getMostDamagedItem(PlayerEntity player) {
        Map map = Enchantments.field_185296_A.func_222181_a((LivingEntity)player);
        Map.Entry mostDamaged = null;
        if (map.isEmpty()) {
            return null;
        }
        double durability = 0.0;
        for (Map.Entry entry : map.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_190926_b() || Utils.getItemEnchantmentLevel(Enchantments.field_185296_A, stack) <= 0 || !(CoreCommonEvents.calcDurabilityRatio(stack) > durability)) continue;
            mostDamaged = entry;
            durability = CoreCommonEvents.calcDurabilityRatio(stack);
        }
        return mostDamaged;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static double calcDurabilityRatio(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }
}

