/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.CustomRenderParticle;
import cofh.core.util.helpers.vfx.VFXHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShockwaveParticle
extends CustomRenderParticle {
    protected float heightScale;
    protected float speed;

    private ShockwaveParticle(ClientWorld worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double speed, double radius, double heightScale) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, radius, speed, heightScale);
        this.field_70547_e = MathHelper.func_76143_f((double)((radius + 6.0) / speed));
        this.speed = (float)speed;
        this.func_187115_a((float)radius * 2.0f, (float)heightScale);
        this.heightScale = (float)heightScale;
        this.field_190017_n = false;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
    }

    @Override
    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLightIn, float partialTicks) {
        VFXHelper.renderShockwave(stack, buffer, (IBlockDisplayReader)this.field_187122_b, new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h), ((float)this.field_70546_d + partialTicks) * this.speed, this.field_187134_n * 0.5f, this.heightScale);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        public Factory(IAnimatedSprite sprite) {
        }

        @Nullable
        public Particle createParticle(BasicParticleType data, ClientWorld world, double x, double y, double z, double speed, double radius, double heightScale) {
            return new ShockwaveParticle(world, x, y, z, speed, radius, heightScale);
        }
    }
}

