/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlastWaveParticle
extends LevelMatrixStackParticle {
    protected float fLifetime;
    protected int seed;

    private BlastWaveParticle(ClientWorld worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double speed, double width, double heightScale) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, width, speed, heightScale);
        this.fLifetime = (float)(width / speed);
        this.field_70547_e = MathHelper.ceil(this.fLifetime);
        this.func_187115_a((float)width, (float)heightScale);
        this.field_190017_n = false;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
    }

    @Override
    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLightIn, float partialTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.field_70546_d + partialTicks;
        float progress = time / this.fLifetime;
        float easeSin = MathHelper.sin(progress * (float)Math.PI * 0.5f);
        float easeCub = MathHelper.easeOutCubic(progress);
        VFXHelper.renderCyclone(stack, buffer, this.func_189214_a(partialTicks), this.field_187134_n * 0.5f * easeSin, this.field_187135_o * easeSin, 2, 0.2f * easeCub, time * 0.05f + (float)rand.nextDouble(69.0), 0.5f * MathHelper.easePlateau(progress));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        public Factory(IAnimatedSprite sprite) {
        }

        @Nullable
        public Particle createParticle(BasicParticleType data, ClientWorld world, double x, double y, double z, double speed, double radius, double heightScale) {
            return new BlastWaveParticle(world, x, y, z, speed, radius, heightScale);
        }
    }
}

