/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.ContainerScreenCoFH;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.client.gui.element.SimpleTooltip;
import cofh.core.inventory.container.TileItemFilterContainer;
import cofh.core.network.packet.server.FilterGuiOpenPacket;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.SoundHelper;
import java.util.Collections;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TileItemFilterScreen
extends ContainerScreenCoFH<TileItemFilterContainer> {
    public static final String TEX_PATH = "cofh_core:textures/gui/generic.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("cofh_core:textures/gui/generic.png");
    public static final String TEX_DENY_LIST = "cofh_core:textures/gui/filters/filter_deny_list.png";
    public static final String TEX_ALLOW_LIST = "cofh_core:textures/gui/filters/filter_allow_list.png";
    public static final String TEX_IGNORE_NBT = "cofh_core:textures/gui/filters/filter_ignore_nbt.png";
    public static final String TEX_USE_NBT = "cofh_core:textures/gui/filters/filter_use_nbt.png";

    public TileItemFilterScreen(TileItemFilterContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super(container, inv, titleIn);
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo("info.cofh_core.item_filter");
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        for (int i = 0; i < ((TileItemFilterContainer)this.field_147002_h).getFilterSize(); ++i) {
            Slot slot = (Slot)((TileItemFilterContainer)this.field_147002_h).field_75151_b.get(i);
            this.addElement(GuiHelper.createSlot(this, slot.field_75223_e, slot.field_75221_f));
        }
        this.addButtons();
        this.addElement(new ElementTexture(this, 4, -21).setUV(24, 0).setSize(24, 21).setTexture("cofh_core:textures/gui/elements/tab_top.png", 48, 32).setVisible(() -> FilterHelper.hasFilter(((TileItemFilterContainer)this.field_147002_h).getFilterableTile())));
        this.addElement(new ElementTexture(this, 8, -17){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                FilterGuiOpenPacket.openTileGui(((TileItemFilterContainer)TileItemFilterScreen.this.field_147002_h).getFilterableTile());
                return true;
            }
        }.setSize(16, 16).setTexture("cofh_core:textures/gui/elements/nav_back.png", 16, 16).setTooltipFactory((element, mouseX, mouseY) -> Collections.singletonList(((TileItemFilterContainer)this.field_147002_h).getFilterableTile().func_145748_c_())).setVisible(() -> FilterHelper.hasFilter(((TileItemFilterContainer)this.field_147002_h).getFilterableTile())));
    }

    protected void addButtons() {
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.field_147002_h).setAllowList(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_DENY_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((ITextComponent)new TranslationTextComponent("info.cofh.filter.allowlist.0"))).setVisible(() -> !((TileItemFilterContainer)this.field_147002_h).getAllowList()));
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.field_147002_h).setAllowList(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_ALLOW_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((ITextComponent)new TranslationTextComponent("info.cofh.filter.allowlist.1"))).setVisible(() -> ((TileItemFilterContainer)this.field_147002_h).getAllowList()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.field_147002_h).setCheckNBT(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_IGNORE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((ITextComponent)new TranslationTextComponent("info.cofh.filter.checkNBT.0"))).setVisible(() -> !((TileItemFilterContainer)this.field_147002_h).getCheckNBT()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.field_147002_h).setCheckNBT(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_USE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((ITextComponent)new TranslationTextComponent("info.cofh.filter.checkNBT.1"))).setVisible(() -> ((TileItemFilterContainer)this.field_147002_h).getCheckNBT()));
    }
}

