/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.network;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.network.ClientMessages;
import com.blamejared.pixelmongo.network.IMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    public static SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)Constants.rl("main"), () -> "0", s -> true, s -> true);
    private static int ID = 0;

    public static void init() {
        for (ClientMessages msg : ClientMessages.values()) {
            PacketHandler.registerMessage(msg.getMessageClass(), msg.getMessageFactory(), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    private static <MSG extends IMessage<MSG>> void registerMessage(Class<MSG> messageType, Function<PacketBuffer, MSG> decoder, Optional<NetworkDirection> direction) {
        PacketHandler.registerMessage(messageType, decoder, (messageCopy, contextSupplier) -> PacketHandler.andHandling(contextSupplier, messageCopy::handle), direction);
    }

    private static <MSG extends IMessage<MSG>> void registerMessage(Class<MSG> messageType, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer, Optional<NetworkDirection> direction) {
        CHANNEL.registerMessage(ID++, messageType, IMessage::serialize, decoder, messageConsumer, direction);
    }

    private static void andHandling(Supplier<NetworkEvent.Context> contextSupplier, Runnable enqueuedWork) {
        contextSupplier.get().enqueueWork(enqueuedWork);
        contextSupplier.get().setPacketHandled(true);
    }
}

