/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.item;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.PixelmonGo;
import com.blamejared.pixelmongo.advancement.trigger.HatchEggTrigger;
import com.blamejared.pixelmongo.api.PixelmonGoAPI;
import com.blamejared.pixelmongo.api.mock.Egg;
import com.blamejared.pixelmongo.api.mock.PokemonEntry;
import com.blamejared.pixelmongo.api.mock.PokemonPool;
import com.blamejared.pixelmongo.api.mock.WeightedCommandEntry;
import com.blamejared.pixelmongo.network.MessageEggSync;
import com.blamejared.pixelmongo.network.PacketHandler;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class EggItem
extends Item {
    public EggItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Constants.group));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        CompoundNBT tag = stack.func_77978_p();
        if (world.field_72995_K || tag == null || !tag.func_74767_n(Constants.rs("hatching"))) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (playerIn instanceof ServerPlayerEntity) {
            CompoundNBT compound;
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            String key = tag.func_74779_i(Constants.rs("key"));
            Optional<Egg> foundEgg = PixelmonGoAPI.INSTANCE.getEgg(key);
            if (foundEgg.isPresent()) {
                Egg egg = foundEgg.get();
                Set<PokemonPool> pools = egg.resolvePools();
                if (pools.isEmpty()) {
                    ChatHandler.sendChat((Entity)player, (String)"Egg('%s') has an invalid pool(s)! Pools: %s", (Object[])new Object[]{egg.name(), String.join((CharSequence)", ", egg.pools().stream().map(s -> "'" + s + "'").collect(Collectors.toSet()))});
                    return ActionResult.func_226250_c_((Object)stack);
                }
                Optional foundPool = pools.stream().skip(world.field_73012_v.nextInt(pools.size())).findFirst();
                if (foundPool.isPresent()) {
                    Optional foundPokemon;
                    PokemonPool pool = (PokemonPool)foundPool.get();
                    boolean givePokemon = true;
                    boolean giveCommand = true;
                    if (pool.singlePool()) {
                        WeightedList weightedPools = new WeightedList();
                        weightedPools.func_226313_a_((Object)"pokemon", pool.pokemonWeight());
                        weightedPools.func_226313_a_((Object)"commands", pool.commandWeight());
                        switch ((String)weightedPools.func_226318_b_(world.field_73012_v)) {
                            case "pokemon": {
                                giveCommand = false;
                                break;
                            }
                            case "commands": {
                                givePokemon = false;
                            }
                        }
                    }
                    if ((pool.pokemon() == null || pool.pokemon().isEmpty()) && pool.commands() == null && pool.commands().isEmpty()) {
                        ChatHandler.sendChat((Entity)player, (String)"Pool('%s') has no Pokemon or Commands!", (Object[])new Object[]{pool.name()});
                        return ActionResult.func_226250_c_((Object)stack);
                    }
                    if (givePokemon && pool.pokemon() != null && (foundPokemon = pool.pokemon().stream().skip(world.field_73012_v.nextInt(pool.pokemon().size())).findFirst()).isPresent()) {
                        PokemonEntry pokemonEntry = (PokemonEntry)foundPokemon.get();
                        Pokemon mon = PokemonFactory.create((Species)((Species)PixelmonSpecies.fromName((String)pokemonEntry.name()).getValue().orElseThrow(() -> new IllegalArgumentException("Invalid name: " + pokemonEntry.name()))));
                        if (pokemonEntry.form() != null) {
                            mon.setForm(pokemonEntry.form());
                        }
                        if (world.field_73012_v.nextDouble() < pokemonEntry.shinyChance()) {
                            mon.setShiny();
                        }
                        int level = pokemonEntry.exactLevel() ? pokemonEntry.min() : world.field_73012_v.nextInt(pokemonEntry.max() - pokemonEntry.min()) + pokemonEntry.min();
                        mon.setLevel(level);
                        PlayerPartyStorage storage = StorageProxy.getParty((ServerPlayerEntity)player);
                        ChatHandler.sendChat((Entity)player, (String)"You just hatched a level %s %s%s from an egg!", (Object[])new Object[]{level, mon.getDisplayName(), TextFormatting.GREEN + "(" + TextFormatting.RESET + mon.getStats().getIVs().getPercentageString(0) + TextFormatting.GREEN + ")"});
                        storage.add(mon);
                    }
                    if (giveCommand && pool.commands() != null) {
                        WeightedList commands = new WeightedList();
                        pool.commands().forEach(weightedCommandEntry -> commands.func_226313_a_(weightedCommandEntry, weightedCommandEntry.weight()));
                        if (!commands.func_234005_b_()) {
                            WeightedCommandEntry commandEntry = (WeightedCommandEntry)commands.func_226318_b_(world.field_73012_v);
                            MinecraftServer server = world.func_73046_m();
                            if (server != null) {
                                CommandSource commandSource = server.func_195573_aM().func_197031_a().func_197024_a((Entity)player).func_201009_a(player.func_213303_ch());
                                for (String command : commandEntry.commands()) {
                                    server.func_195571_aL().func_197059_a(commandSource, command);
                                }
                            }
                        }
                    }
                }
            }
            int hatchedAmount = (compound = player.getPersistentData().func_74775_l("PlayerPersisted")).func_74764_b(Constants.rs("hatched")) ? compound.func_74762_e(Constants.rs("hatched")) : 0;
            compound.func_74768_a(Constants.rs("hatched"), ++hatchedAmount);
            player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)compound);
            HatchEggTrigger.INSTANCE.trigger(player, hatchedAmount);
            stack.func_190918_g(1);
        }
        return ActionResult.func_233538_a_((Object)stack, (boolean)world.func_201670_d());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            Optional<Egg> foundEgg = PixelmonGoAPI.INSTANCE.getEgg(tag.func_74779_i(Constants.rs("key")));
            foundEgg.ifPresent(egg -> tooltip.add((ITextComponent)new StringTextComponent(Math.floor(tag.func_74769_h(Constants.rs("distance")) * 100.0) / 100.0 + "m/" + egg.distance() + "m")));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        CompoundNBT tag = stack.func_77978_p();
        boolean update = false;
        if (world.field_72995_K) {
            return;
        }
        if (tag == null) {
            return;
        }
        if (!(entity instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        if (!tag.func_74767_n(Constants.rs("initialized"))) {
            tag.func_74757_a(Constants.rs("initialized"), true);
            tag.func_74780_a(Constants.rs("posX"), entity.func_213303_ch().field_72450_a);
            tag.func_74780_a(Constants.rs("posY"), entity.func_213303_ch().field_72448_b);
            tag.func_74780_a(Constants.rs("posZ"), entity.func_213303_ch().field_72449_c);
            tag.func_74757_a(Constants.rs("hatching"), false);
        }
        if (tag.func_74767_n(Constants.rs("hatching"))) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            double posX = tag.func_74769_h(Constants.rs("posX"));
            double posY = tag.func_74769_h(Constants.rs("posY"));
            double posZ = tag.func_74769_h(Constants.rs("posZ"));
            double totalDistance = PixelmonGoAPI.INSTANCE.getEgg(tag.func_74779_i(Constants.rs("key"))).map(Egg::distance).orElse(-1).intValue();
            if (posX != entity.field_70142_S || posZ != entity.field_70136_U) {
                double distance = tag.func_74769_h(Constants.rs("distance"));
                tag.func_74780_a(Constants.rs("distance"), distance += (double)MathHelper.func_76131_a((float)MathHelper.func_76133_a((double)entity.func_70092_e(posX, posY, posZ)), (float)0.0f, (float)50.0f));
                if (distance >= totalDistance) {
                    tag.func_74757_a(Constants.rs("hatching"), true);
                    update = true;
                }
            }
        }
        tag.func_74780_a(Constants.rs("posX"), entity.func_213303_ch().field_72450_a);
        tag.func_74780_a(Constants.rs("posY"), entity.func_213303_ch().field_72448_b);
        tag.func_74780_a(Constants.rs("posZ"), entity.func_213303_ch().field_72449_c);
        if (update) {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageEggSync(slot, tag));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return new StringTextComponent("Invalid Egg!");
        }
        String eggKey = tag.func_74779_i(Constants.rs("key"));
        return new StringTextComponent(PixelmonGoAPI.INSTANCE.getEgg(eggKey).map(Egg::name).orElse("Unknown Egg"));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            PixelmonGoAPI.INSTANCE.getEggs().values().forEach(egg -> stacks.add((Object)this.makeStack((Egg)egg)));
        }
    }

    public ItemStack func_190903_i() {
        Optional<Egg> first = PixelmonGoAPI.INSTANCE.getEggs().values().stream().findFirst();
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (first.isPresent()) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74778_a(Constants.rs("key"), first.get().name());
        }
        return stack;
    }

    private ItemStack makeStack(Egg egg) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a(Constants.rs("initialized"), false);
        tag.func_74778_a(Constants.rs("key"), egg.name());
        tag.func_74780_a(Constants.rs("distance"), 0.0);
        tag.func_74780_a(Constants.rs("totalDistance"), (double)egg.distance());
        tag.func_74757_a(Constants.rs("hatching"), false);
        return stack;
    }

    public static boolean isHatching(ItemStack stack) {
        return stack.func_77973_b() == PixelmonGo.EGG && stack.func_77942_o() && stack.func_196082_o().func_74767_n(Constants.rs("hatching"));
    }
}

