/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.config;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.api.PixelmonGoAPI;
import com.blamejared.pixelmongo.api.mock.Egg;
import com.blamejared.pixelmongo.api.mock.PokemonEntry;
import com.blamejared.pixelmongo.api.mock.PokemonPool;
import com.blamejared.pixelmongo.api.mock.Pokestop;
import com.blamejared.pixelmongo.api.mock.WeightedCommandEntry;
import com.blamejared.pixelmongo.api.mock.WeightedItemStackEntry;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Config {
    private static final TypeToken<?> EGG_TYPE = TypeToken.getParameterized(Set.class, (Type[])new Type[]{Egg.class});
    private static final TypeToken<?> POKEMON_POOL_TYPE = TypeToken.getParameterized(Set.class, (Type[])new Type[]{PokemonPool.class});
    private static final TypeToken<?> POKESTOP_POOL_TYPE = TypeToken.getParameterized(Set.class, (Type[])new Type[]{WeightedItemStackEntry.class});

    public static void init() {
        try {
            Config.ensureExists();
            Config.readConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void readConfig() throws IOException {
        Set eggs = (Set)Constants.GSON.fromJson(new String(Files.readAllBytes(Constants.CONFIG_EGGS)), EGG_TYPE.getType());
        eggs.forEach(PixelmonGoAPI.INSTANCE::registerEgg);
        Set pokemonPools = (Set)Constants.GSON.fromJson(new String(Files.readAllBytes(Constants.CONFIG_POKEMON_POOLS)), POKEMON_POOL_TYPE.getType());
        pokemonPools.forEach(PixelmonGoAPI.INSTANCE::registerPokemonPool);
        Set pokestopPools = (Set)Constants.GSON.fromJson(new String(Files.readAllBytes(Constants.CONFIG_POKESTOP_POOLS)), POKESTOP_POOL_TYPE.getType());
        pokestopPools.forEach(PixelmonGoAPI.INSTANCE::registerPokestopPoolItem);
        Pokestop pokestop = (Pokestop)Constants.GSON.fromJson(new String(Files.readAllBytes(Constants.CONFIG_POKESTOP)), Pokestop.class);
        PixelmonGoAPI.INSTANCE.pokestop(pokestop);
    }

    private static void ensureExists() throws IOException {
        AbstractCollection pools;
        Throwable throwable;
        BufferedWriter writer;
        if (Files.notExists(Constants.CONFIG_FOLDER, new LinkOption[0])) {
            try {
                Files.createDirectories(Constants.CONFIG_FOLDER, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (Files.notExists(Constants.CONFIG_EGGS, new LinkOption[0])) {
            HashSet<Egg> eggs = new HashSet<Egg>();
            eggs.add(new Egg("Water egg", 2000, Collections.singleton("water"), 255));
            eggs.add(new Egg("Fire egg", 200, Collections.singleton("fire"), 0xAA0000));
            writer = new BufferedWriter(new FileWriter(Constants.CONFIG_EGGS.toFile()));
            throwable = null;
            try {
                writer.write(Constants.GSON.toJson(eggs, EGG_TYPE.getType()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        if (Files.notExists(Constants.CONFIG_POKEMON_POOLS, new LinkOption[0])) {
            pools = new HashSet();
            HashSet<WeightedCommandEntry> commands = new HashSet<WeightedCommandEntry>();
            commands.add(new WeightedCommandEntry(Arrays.asList("give @p minecraft:apple", "give @p minecraft:diamond"), 1));
            commands.add(new WeightedCommandEntry(Collections.singletonList("effect give @p minecraft:haste"), 5));
            pools.add(new PokemonPool("fire", Collections.singleton(new PokemonEntry("vulpix", 1, 50, false, null)), commands));
            pools.add(new PokemonPool("water", Collections.singleton(new PokemonEntry("samurott", 5, 5, true, "hisuian")), Collections.emptySet()));
            pools.add(new PokemonPool("grass", Collections.singleton(new PokemonEntry("bulbasaur", 5, 6, false, null)), commands, true, 5, 1));
            try (BufferedWriter writer2 = new BufferedWriter(new FileWriter(Constants.CONFIG_POKEMON_POOLS.toFile()));){
                writer2.write(Constants.GSON.toJson((Object)pools, POKEMON_POOL_TYPE.getType()));
            }
        }
        if (Files.notExists(Constants.CONFIG_POKESTOP_POOLS, new LinkOption[0])) {
            pools = new ArrayList();
            pools.add((WeightedItemStackEntry)new WeightedItemStackEntry("minecraft:apple", 5, null, 10));
            pools.add(new WeightedItemStackEntry("minecraft:diamond", 1, null, 2));
            pools.add(new WeightedItemStackEntry("pixelmongo:egg", 1, "{\"pixelmongo:key\": \"Water egg\"}", 20));
            pools.add(new WeightedItemStackEntry("pixelmongo:egg", 1, "{\"pixelmongo:key\": \"Fire egg\"}", 20));
            writer = new BufferedWriter(new FileWriter(Constants.CONFIG_POKESTOP_POOLS.toFile()));
            throwable = null;
            try {
                writer.write(Constants.GSON.toJson((Object)pools, POKESTOP_POOL_TYPE.getType()));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        if (Files.notExists(Constants.CONFIG_POKESTOP, new LinkOption[0])) {
            try (BufferedWriter writer3 = new BufferedWriter(new FileWriter(Constants.CONFIG_POKESTOP.toFile()));){
                writer3.write(Constants.GSON.toJson((Object)new Pokestop(false, 15, 7, 3, 5)));
            }
        }
    }
}

