/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.block;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.block.entity.PokestopBlockEntity;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.server.ServerWorld;

public class PokestopBlock
extends Block {
    public PokestopBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_235838_a_(value -> 15).func_200948_a(-1.0f, 3600000.0f));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof PokestopBlockEntity)) {
            return ActionResultType.FAIL;
        }
        if (level.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        PokestopBlockEntity tile = (PokestopBlockEntity)blockEntity;
        UUID uuid = player.func_110124_au();
        if (tile.playerTime().containsKey(uuid)) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Pokestop on cooldown! Can only be used in: " + tile.playerTime().getOrDefault(uuid, 0) / 20 + " seconds!"), Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            int index = world.field_73012_v.nextInt(4) + 1;
            serverWorld.func_184163_y().func_200219_b(Constants.rl("pokestop_" + index)).func_237152_b_((IServerWorld)serverWorld, pos, new PlacementSettings(), new Random(index));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PokestopBlockEntity();
    }
}

