/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.block;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.api.PixelmonGoAPI;
import com.blamejared.pixelmongo.api.mock.Egg;
import com.blamejared.pixelmongo.block.entity.IncubatorBlockEntity;
import com.blamejared.pixelmongo.item.EggItem;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IncubatorBlock
extends Block {
    protected static final VoxelShape COLLISION_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public IncubatorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(-1.0f, 3600000.0f).func_226896_b_().func_200948_a(1.5f, 6.0f).func_235847_c_((p_test_1_, p_test_2_, p_test_3_) -> false));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof IncubatorBlockEntity)) {
            return ActionResultType.FAIL;
        }
        IncubatorBlockEntity incubator = (IncubatorBlockEntity)blockEntity;
        boolean active = (Boolean)state.func_177229_b((Property)ACTIVE);
        if (active) {
            Optional<ItemStack> itemStack = incubator.eggStack();
            itemStack.ifPresent(egg -> {
                if (EggItem.isHatching(egg)) {
                    egg = egg.func_77946_l();
                    if (stack.func_190926_b()) {
                        player.func_184611_a(hand, egg);
                    } else if (!player.func_191521_c(egg)) {
                        player.func_71019_a(egg, false);
                    }
                    incubator.eggStack(ItemStack.field_190927_a);
                    level.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                } else {
                    CompoundNBT tag = egg.func_77978_p();
                    if (tag != null) {
                        Optional<Egg> foundEgg = PixelmonGoAPI.INSTANCE.getEgg(tag.func_74779_i(Constants.rs("key")));
                        foundEgg.ifPresent(egg1 -> player.func_146105_b((ITextComponent)new StringTextComponent(Math.floor(tag.func_74769_h(Constants.rs("distance")) * 100.0) / 100.0 + "m/" + egg1.distance() + "m"), true));
                    }
                }
            });
        } else {
            if (!(stack.func_77973_b() instanceof EggItem)) {
                return ActionResultType.FAIL;
            }
            incubator.eggStack(stack.func_77946_l());
            stack.func_190918_g(1);
            level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return COLLISION_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return COLLISION_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{ACTIVE});
    }

    public VoxelShape func_230322_a_(BlockState p_230322_1_, IBlockReader p_230322_2_, BlockPos p_230322_3_, ISelectionContext p_230322_4_) {
        return VoxelShapes.func_197880_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return p_200122_2_.func_203425_a((Block)this) ? true : super.func_200122_a(p_200122_1_, p_200122_2_, p_200122_3_);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new IncubatorBlockEntity();
    }
}

