/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.api.mock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class WeightedItemStackEntry {
    private final String item;
    private final int count;
    private final String nbt;
    private final int weight;

    public WeightedItemStackEntry(String item, int count, String nbt, int weight) {
        this.item = item;
        this.count = count;
        this.nbt = nbt;
        this.weight = weight;
    }

    public String item() {
        return this.item;
    }

    public int count() {
        return this.count;
    }

    public String nbt() {
        return this.nbt;
    }

    public int weight() {
        return this.weight;
    }

    public Resolved resolve() {
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(this.item)).orElseThrow(() -> new IllegalArgumentException("Cannot create item from given string: '" + this.item + "'"));
        ItemStack stack = new ItemStack((IItemProvider)item, this.count);
        if (this.nbt() != null) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)this.nbt));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return new Resolved(stack, this.weight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedItemStackEntry that = (WeightedItemStackEntry)o;
        if (this.count != that.count) {
            return false;
        }
        if (this.weight != that.weight) {
            return false;
        }
        if (!Objects.equals(this.item, that.item)) {
            return false;
        }
        return Objects.equals(this.nbt, that.nbt);
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + this.count;
        result = 31 * result + (this.nbt != null ? this.nbt.hashCode() : 0);
        result = 31 * result + this.weight;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WeightedItemStackEntry{");
        sb.append("item='").append(this.item).append('\'');
        sb.append(", count=").append(this.count);
        sb.append(", nbt='").append(this.nbt).append('\'');
        sb.append(", weight=").append(this.weight);
        sb.append('}');
        return sb.toString();
    }

    public class Resolved {
        private final ItemStack stack;
        private final int weight;

        public Resolved(ItemStack stack, int weight) {
            this.stack = stack;
            this.weight = weight;
        }

        public ItemStack stack() {
            return this.stack;
        }

        public int weight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resolved resolved = (Resolved)o;
            if (this.weight != resolved.weight) {
                return false;
            }
            return Objects.equals(this.stack, resolved.stack);
        }

        public int hashCode() {
            int result = this.stack != null ? this.stack.hashCode() : 0;
            result = 31 * result + this.weight;
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Resolved{");
            sb.append("stack=").append(this.stack);
            sb.append(", weight=").append(this.weight);
            sb.append('}');
            return sb.toString();
        }
    }
}

