/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.api.mock;

import com.blamejared.pixelmongo.api.mock.PokemonEntry;
import com.blamejared.pixelmongo.api.mock.WeightedCommandEntry;
import java.util.Objects;
import java.util.Set;

public class PokemonPool {
    private final String name;
    private final Set<PokemonEntry> pokemon;
    private final Set<WeightedCommandEntry> commands;
    private final boolean singlePool;
    private final int pokemonWeight;
    private final int commandWeight;

    public PokemonPool(String name, Set<PokemonEntry> pokemon, Set<WeightedCommandEntry> commands) {
        this.name = name;
        this.pokemon = pokemon;
        this.commands = commands;
        this.singlePool = false;
        this.pokemonWeight = 1;
        this.commandWeight = 1;
    }

    public PokemonPool(String name, Set<PokemonEntry> pokemon, Set<WeightedCommandEntry> commands, boolean singlePool, int pokemonWeight, int commandWeight) {
        this.name = name;
        this.pokemon = pokemon;
        this.commands = commands;
        this.singlePool = singlePool;
        this.pokemonWeight = pokemonWeight;
        this.commandWeight = commandWeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PokemonPool that = (PokemonPool)o;
        return this.singlePool == that.singlePool && this.pokemonWeight == that.pokemonWeight && this.commandWeight == that.commandWeight && Objects.equals(this.name, that.name) && Objects.equals(this.pokemon, that.pokemon) && Objects.equals(this.commands, that.commands);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pokemon, this.commands, this.singlePool, this.pokemonWeight, this.commandWeight);
    }

    public String name() {
        return this.name;
    }

    public Set<PokemonEntry> pokemon() {
        return this.pokemon;
    }

    public Set<WeightedCommandEntry> commands() {
        return this.commands;
    }

    public boolean singlePool() {
        return this.singlePool;
    }

    public int pokemonWeight() {
        return this.pokemonWeight;
    }

    public int commandWeight() {
        return this.commandWeight;
    }
}

