/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.api.mock;

import java.util.Objects;
import java.util.StringJoiner;

public class PokemonEntry {
    private final String name;
    private final int min;
    private final int max;
    private final boolean exactLevel;
    private final String form;
    private final double shinyChance;

    public PokemonEntry(String name, int min, int max, boolean exactLevel, String form) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.exactLevel = exactLevel;
        this.form = form;
        this.shinyChance = 2.44140625E-4;
    }

    public PokemonEntry(String name, int min, int max, boolean exactLevel, String form, double shinyChance) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.exactLevel = exactLevel;
        this.form = form;
        this.shinyChance = shinyChance;
    }

    public String name() {
        return this.name;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public boolean exactLevel() {
        return this.exactLevel;
    }

    public String form() {
        return this.form;
    }

    public double shinyChance() {
        return this.shinyChance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PokemonEntry that = (PokemonEntry)o;
        if (this.min != that.min) {
            return false;
        }
        if (this.max != that.max) {
            return false;
        }
        if (this.exactLevel != that.exactLevel) {
            return false;
        }
        if (Double.compare(that.shinyChance, this.shinyChance) != 0) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.form, that.form);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        result = 31 * result + (this.exactLevel ? 1 : 0);
        result = 31 * result + (this.form != null ? this.form.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.shinyChance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", PokemonEntry.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("min=" + this.min).add("max=" + this.max).add("exactLevel=" + this.exactLevel).add("form='" + this.form + "'").add("shinyChance=" + this.shinyChance).toString();
    }
}

