/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.api.mock;

import com.blamejared.pixelmongo.api.PixelmonGoAPI;
import com.blamejared.pixelmongo.api.mock.PokemonPool;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Egg {
    private final String name;
    private final int distance;
    private final Set<String> pools;
    private final int color;

    public Egg(String name, int distance, Set<String> pools, int color) {
        this.name = name;
        this.distance = distance;
        this.pools = pools;
        this.color = color;
    }

    public String name() {
        return this.name;
    }

    public int distance() {
        return this.distance;
    }

    public Set<String> pools() {
        return this.pools;
    }

    public Set<PokemonPool> resolvePools() {
        return this.pools.stream().map(PixelmonGoAPI.INSTANCE::getPokemonPool).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public int color() {
        return this.color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Egg egg = (Egg)o;
        if (this.distance != egg.distance) {
            return false;
        }
        if (this.color != egg.color) {
            return false;
        }
        if (!Objects.equals(this.name, egg.name)) {
            return false;
        }
        return Objects.equals(this.pools, egg.pools);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.distance;
        result = 31 * result + (this.pools != null ? this.pools.hashCode() : 0);
        result = 31 * result + this.color;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Egg{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", distance=").append(this.distance);
        sb.append(", pools=").append(this.pools);
        sb.append(", color=").append(this.color);
        sb.append('}');
        return sb.toString();
    }
}

