/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo.api;

import com.blamejared.pixelmongo.api.mock.Egg;
import com.blamejared.pixelmongo.api.mock.PokemonPool;
import com.blamejared.pixelmongo.api.mock.Pokestop;
import com.blamejared.pixelmongo.api.mock.WeightedItemStackEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.WeightedList;

public final class PixelmonGoAPI {
    public static final PixelmonGoAPI INSTANCE = new PixelmonGoAPI();
    private final Map<String, Egg> eggs = new HashMap<String, Egg>();
    private final Map<String, PokemonPool> pokemonPools = new HashMap<String, PokemonPool>();
    private final List<WeightedItemStackEntry> pokestopPool = new ArrayList<WeightedItemStackEntry>();
    private Pokestop pokestop = new Pokestop(false, 15, 7, 3, 9);

    private PixelmonGoAPI() {
    }

    public void registerEgg(Egg egg) {
        this.eggs.put(egg.name(), egg);
    }

    public void registerPokemonPool(PokemonPool pool) {
        this.pokemonPools.put(pool.name(), pool);
    }

    public void registerPokestopPoolItem(WeightedItemStackEntry entry) {
        this.pokestopPool.add(entry);
    }

    public Optional<Egg> getEgg(String key) {
        return Optional.ofNullable(this.eggs.get(key));
    }

    public Optional<PokemonPool> getPokemonPool(String key) {
        return Optional.ofNullable(this.pokemonPools.get(key));
    }

    public Map<String, Egg> getEggs() {
        return this.eggs.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.eggs);
    }

    public Map<String, PokemonPool> getPokemonPools() {
        return this.pokemonPools.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.pokemonPools);
    }

    public WeightedList<WeightedItemStackEntry.Resolved> getWeightedPokestopPool() {
        WeightedList list = new WeightedList();
        this.pokestopPool.stream().map(WeightedItemStackEntry::resolve).forEach(entry -> list.func_226313_a_(entry, entry.weight()));
        return list;
    }

    public List<WeightedItemStackEntry> getPokestopPool() {
        return new ArrayList<WeightedItemStackEntry>(this.pokestopPool);
    }

    public Pokestop pokestop() {
        return this.pokestop;
    }

    public void pokestop(Pokestop pokestop) {
        this.pokestop = pokestop;
    }
}

