/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.PixelmonGo;
import com.blamejared.pixelmongo.api.PixelmonGoAPI;
import com.blamejared.pixelmongo.api.mock.Egg;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.opengl.GL11;

public class PixelmonGoClient {
    private static int lastX;
    private static int lastY;

    public static void construct() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PixelmonGoClient::itemColours);
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(PixelmonGoClient::eggOverlay);
        RenderTypeLookup.setRenderLayer((Block)PixelmonGo.INCUBATOR, (RenderType)RenderType.func_228645_f_());
        ItemModelsProperties.func_239418_a_((Item)PixelmonGo.EGG, (ResourceLocation)Constants.rl("hatching"), (stack, level, entity) -> {
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                return 0.0f;
            }
            return tag.func_74767_n(Constants.rs("hatching")) ? 1.0f : 0.0f;
        });
    }

    public static void itemColours(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, provider) -> {
            if (stack.func_77942_o()) {
                CompoundNBT tag = stack.func_196082_o();
                String key = tag.func_74779_i(Constants.rs("key"));
                return PixelmonGoAPI.INSTANCE.getEgg(key).map(Egg::color).orElse(0);
            }
            return 0xFFFFFF;
        }, new IItemProvider[]{PixelmonGo.EGG});
    }

    private static void eggOverlay(RenderGameOverlayEvent e) {
        boolean hasItem = false;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack item;
            if (hasItem || (item = player.field_71071_by.func_70301_a(i)).func_77973_b() != PixelmonGo.EGG || item.func_77978_p() == null || !item.func_77978_p().func_74767_n(Constants.rs("hatching"))) continue;
            hasItem = true;
        }
        IngameGui gui = mc.field_71456_v;
        ClientWorld level = mc.field_71441_e;
        if (!hasItem || e.getType() != RenderGameOverlayEvent.ElementType.ALL || gui == null || level == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)-128.0, (double)-128.0, (double)0.0);
        if (level.field_73012_v.nextInt(20) % 10 == 0) {
            lastX = level.field_73012_v.nextInt(20) - 10;
            lastY = level.field_73012_v.nextInt(20) - 10;
        }
        GL11.glTranslated((double)lastX, (double)lastY, (double)0.0);
        mc.func_110434_K().func_110577_a(Constants.rl("textures/items/egg.png"));
        gui.func_238474_b_(e.getMatrixStack(), e.getWindow().func_198107_o() / 2, e.getWindow().func_198087_p() / 2, 0, 0, 256, 256);
        GL11.glPopMatrix();
    }
}

