/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.pixelmongo;

import com.blamejared.pixelmongo.Constants;
import com.blamejared.pixelmongo.PixelmonGoClient;
import com.blamejared.pixelmongo.advancement.trigger.HatchEggTrigger;
import com.blamejared.pixelmongo.advancement.trigger.SpinStopTrigger;
import com.blamejared.pixelmongo.api.PixelmonGoAPI;
import com.blamejared.pixelmongo.block.IncubatorBlock;
import com.blamejared.pixelmongo.block.PokestopBlock;
import com.blamejared.pixelmongo.block.entity.IncubatorBlockEntity;
import com.blamejared.pixelmongo.block.entity.PokestopBlockEntity;
import com.blamejared.pixelmongo.client.RenderPokestop;
import com.blamejared.pixelmongo.config.Config;
import com.blamejared.pixelmongo.item.EggItem;
import com.blamejared.pixelmongo.network.PacketHandler;
import com.blamejared.pixelmongo.world.structure.PokestopStructure;
import com.blamejared.pixelmongo.world.structure.piece.PokestopStructurePiece;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="pixelmongo")
public class PixelmonGo {
    public static final Item EGG = new EggItem();
    public static final Block POKESTOP = new PokestopBlock();
    public static final Block INCUBATOR = new IncubatorBlock();
    public static final TileEntityType<PokestopBlockEntity> TILE_POKESTOP = new TileEntityType(PokestopBlockEntity::new, Collections.singleton(POKESTOP), null);
    public static final TileEntityType<IncubatorBlockEntity> TILE_INCUBATOR = new TileEntityType(IncubatorBlockEntity::new, Collections.singleton(INCUBATOR), null);
    public static final IStructurePieceType STRUCTURE_PIECE_POKESTOP = PokestopStructurePiece::new;
    public static final PokestopStructure STRUCTURE_POKESTOP = new PokestopStructure();
    public static StructureFeature<?, ?> CONFIGURED_POKESTOP = STRUCTURE_POKESTOP.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    private static Method GETCODEC_METHOD;

    public PixelmonGo() {
        Config.init();
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Structure.class, this::registerStructures);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerBlockEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::biomeModification);
        PacketHandler.init();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> PixelmonGoClient::construct);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        if (PixelmonGoAPI.INSTANCE.getEggs().isEmpty()) {
            throw new IllegalStateException("No registered PixelmonGo Eggs! Make sure the config is valid");
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        PixelmonGo.setupStructures();
        PixelmonGo.registerConfiguredStructures();
        event.enqueueWork(() -> {
            CriteriaTriggers.func_192118_a((ICriterionTrigger)HatchEggTrigger.INSTANCE);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)SpinStopTrigger.INSTANCE);
        });
    }

    private void setupClient(FMLClientSetupEvent event) {
        PixelmonGoClient.init();
        ClientRegistry.bindTileEntityRenderer(TILE_POKESTOP, RenderPokestop::new);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(POKESTOP.setRegistryName(Constants.rl("pokestop")));
        event.getRegistry().register(INCUBATOR.setRegistryName(Constants.rl("incubator")));
    }

    public void registerBlockEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(TILE_POKESTOP.setRegistryName(Constants.rl("pokestop")));
        event.getRegistry().register(TILE_INCUBATOR.setRegistryName(Constants.rl("incubator")));
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(EGG.setRegistryName(Constants.rl("egg")));
        event.getRegistry().register(new BlockItem(POKESTOP, new Item.Properties().func_200916_a(Constants.group)).setRegistryName(Constants.rl("pokestop")));
        event.getRegistry().register(new BlockItem(INCUBATOR, new Item.Properties().func_200916_a(Constants.group)).setRegistryName(Constants.rl("incubator")));
    }

    public void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        event.getRegistry().register(STRUCTURE_POKESTOP.setRegistryName(Constants.rl("pokestop")));
    }

    public static void setupStructures() {
        PixelmonGo.setupMapSpacingAndLand(STRUCTURE_POKESTOP, new StructureSeparationSettings(PixelmonGoAPI.INSTANCE.pokestop().averageDistance(), PixelmonGoAPI.INSTANCE.pokestop().minDistance(), 318275185), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    public static void registerConfiguredStructures() {
        Registry registry = WorldGenRegistries.field_243654_f;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)Constants.rl("configured_pokestop"), CONFIGURED_POKESTOP);
        FlatGenerationSettings.field_202247_j.put(STRUCTURE_POKESTOP, CONFIGURED_POKESTOP);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        event.getGeneration().getStructures().add(() -> CONFIGURED_POKESTOP);
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<PokestopStructure, Object> tempMap = new HashMap<PokestopStructure, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(STRUCTURE_POKESTOP, DimensionStructuresSettings.field_236191_b_.get((Object)STRUCTURE_POKESTOP));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

