/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptLearnEvent;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class Util {
    public static final UUID DUMMY_UUID = new UUID(0L, 0L);

    @Nullable
    public static ServerPlayerEntity getPlayer(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer() == null ? null : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
    }

    @Nullable
    public static ServerPlayerEntity getPlayer(@Nullable World world, UUID uuid) {
        return world == null || world.func_73046_m() == null ? null : world.func_73046_m().func_184103_al().func_177451_a(uuid);
    }

    public static ItemStack cleanStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        if (stackCopy.func_77984_f()) {
            stackCopy.func_196085_b(0);
        }
        return NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)stackCopy)).createStack();
    }

    public static AddKnowledgeResult addKnowledge(PlayerEntity player, IKnowledgeProvider provider, Item rawItem, Item cleanItem) {
        return Util.addKnowledge(player, provider, ItemInfo.fromItem((Item)rawItem), ItemInfo.fromItem((Item)cleanItem));
    }

    public static AddKnowledgeResult addKnowledge(PlayerEntity player, IKnowledgeProvider provider, ItemStack rawStack, ItemStack cleanStack) {
        return Util.addKnowledge(player, provider, ItemInfo.fromStack((ItemStack)rawStack), ItemInfo.fromStack((ItemStack)cleanStack));
    }

    public static AddKnowledgeResult addKnowledge(PlayerEntity player, IKnowledgeProvider provider, ItemInfo rawInfo, ItemInfo cleanInfo) {
        if (cleanInfo.createStack().func_190926_b()) {
            return AddKnowledgeResult.FAIL;
        }
        if (!provider.hasKnowledge(cleanInfo)) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptLearnEvent(player, rawInfo, cleanInfo))) {
                return AddKnowledgeResult.FAIL;
            }
            provider.addKnowledge(cleanInfo);
            return AddKnowledgeResult.SUCCESS;
        }
        return AddKnowledgeResult.UNKNOWN;
    }

    public static int safeIntValue(BigInteger val) {
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public static int safeIntValue(BigDecimal val) {
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public static long safeLongValue(BigInteger val) {
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException ignore) {
            return Long.MAX_VALUE;
        }
    }

    public static int mod(int a, int b) {
        return (a %= b) < 0 ? a + b : a;
    }

    public static void markDirty(TileEntity block) {
        if (block.func_145831_w() != null) {
            Util.markDirty(block.func_145831_w(), block);
        }
    }

    public static void markDirty(World level, TileEntity block) {
        Util.markDirty(level, block.func_174877_v());
    }

    public static void markDirty(World level, BlockPos pos) {
        level.func_175726_f(pos).func_177427_f(true);
    }

    @Nullable
    public static IKnowledgeProvider getKnowledgeProvider(UUID uuid) {
        ServerPlayerEntity player = Util.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return Util.getKnowledgeProvider((PlayerEntity)player);
    }

    @Nullable
    public static IKnowledgeProvider getKnowledgeProvider(PlayerEntity player) {
        try {
            return (IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public static BigInteger spreadEMC(BigInteger emc, List<IEmcStorage> storageList) {
        return Util.spreadEMC(emc, storageList, null);
    }

    public static BigInteger spreadEMC(BigInteger emc, List<IEmcStorage> storageList, @Nullable Long maxPer) {
        if (emc.equals(BigInteger.ZERO) || storageList.isEmpty()) {
            return emc;
        }
        ArrayList notAccepting = new ArrayList();
        emc = Util.stepBigInteger(emc, (Long val) -> {
            long div = val / (long)storageList.size();
            if (maxPer != null && maxPer < div) {
                div = maxPer;
            }
            block0: while (val > 0L && notAccepting.size() < storageList.size()) {
                for (IEmcStorage storage : storageList) {
                    if (notAccepting.contains(storage)) continue;
                    if (val == 0L) break block0;
                    if (val < div) {
                        div = val;
                    }
                    long oldVal = val;
                    if ((val = Long.valueOf(val - storage.insertEmc(div, IEmcStorage.EmcAction.EXECUTE))).equals(oldVal)) {
                        notAccepting.add(storage);
                    }
                    if (maxPer == null || oldVal - val < maxPer) continue;
                    notAccepting.add(storage);
                }
            }
            return val;
        });
        return emc;
    }

    public static BigInteger stepBigInteger(BigInteger value, Function<Long, Long> func) {
        return Util.stepBigInteger(value, (Long)Long.MAX_VALUE, func);
    }

    public static BigInteger stepBigInteger(BigInteger value, Long step, Function<Long, Long> func) {
        return Util.stepBigInteger(value, step, (Long a, BigInteger b) -> (Long)func.apply((Long)a));
    }

    public static BigInteger stepBigInteger(BigInteger value, BiFunction<Long, BigInteger, Long> func) {
        return Util.stepBigInteger(value, (Long)Long.MAX_VALUE, func);
    }

    public static BigInteger stepBigInteger(BigInteger value, Long step, BiFunction<Long, BigInteger, Long> func) {
        long localValue;
        if (value.equals(BigInteger.ZERO)) {
            return value;
        }
        while ((localValue = Math.min(step, Util.safeLongValue(value))) > 0L) {
            value = value.subtract(BigInteger.valueOf(localValue));
            Long unused = func.apply(localValue, value);
            if (unused <= 0L) continue;
            value = value.add(BigInteger.valueOf(unused));
            break;
        }
        return value;
    }

    @Nullable
    public static ServerWorld getDimension(RegistryKey<World> dimension) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(dimension);
    }

    public static Style suggestCommand(Style style, String command) {
        return style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(command).func_240699_a_(TextFormatting.RED)));
    }

    public static void sendSystemMessage(PlayerEntity player, ITextComponent content, UUID uuid) {
        player.func_145747_a(content, uuid);
    }

    public static void sendSystemMessage(PlayerEntity player, ITextComponent content) {
        Util.sendSystemMessage(player, content, DUMMY_UUID);
    }

    public static void sendSystemMessage(CommandSource ctx, ITextComponent content, boolean broadcast) {
        ctx.func_197030_a(content, broadcast);
    }

    public static void sendSystemMessage(CommandSource ctx, ITextComponent content) {
        Util.sendSystemMessage(ctx, content, false);
    }

    public static enum AddKnowledgeResult {
        FAIL,
        UNKNOWN,
        SUCCESS;

    }
}

