/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.item.ItemColossalStar;
import cool.furry.mc.forge.projectexpansion.item.ItemMagnumStar;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraftforge.fml.RegistryObject;

public enum Star {
    EIN("ein"),
    ZWEI("zwei"),
    DREI("drei"),
    VIER("vier"),
    SPHERE("sphere"),
    OMEGA("omega");

    public static final Star[] VALUES;
    public final String name;
    @Nullable
    private RegistryObject<ItemMagnumStar> itemMagnum = null;
    @Nullable
    private RegistryObject<ItemColossalStar> itemColossal = null;

    public Star prev() {
        return VALUES[(this.ordinal() - 1 + VALUES.length) % VALUES.length];
    }

    public Star next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    private Star(String name) {
        this.name = name;
    }

    @Nullable
    public Star getPrev() {
        return this == EIN ? null : VALUES[this.ordinal() - 1];
    }

    @Nullable
    public ItemMagnumStar asMagnumItem() {
        return this.itemMagnum == null ? null : (ItemMagnumStar)this.itemMagnum.get();
    }

    @Nullable
    public ItemColossalStar asColossalItem() {
        return this.itemColossal == null ? null : (ItemColossalStar)this.itemColossal.get();
    }

    private void registerMagnum() {
    }

    private void register(RegistrationType reg) {
        switch (reg) {
            case MAGNUM: {
                this.itemMagnum = Items.Registry.register(String.format("magnum_star_%s", this.name), () -> new ItemMagnumStar(this));
                break;
            }
            case COLOSSAL: {
                this.itemColossal = Items.Registry.register(String.format("colossal_star_%s", this.name), () -> new ItemColossalStar(this));
            }
        }
    }

    public static void registerAll() {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.register((RegistrationType)((Object)type))));
    }

    static {
        VALUES = Star.values();
    }

    private static enum RegistrationType {
        MAGNUM,
        COLOSSAL;

    }
}

