/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.block.BlockCollector;
import cool.furry.mc.forge.projectexpansion.block.BlockEMCLink;
import cool.furry.mc.forge.projectexpansion.block.BlockPowerFlower;
import cool.furry.mc.forge.projectexpansion.block.BlockRelay;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.item.ItemCompressedEnergyCollector;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.RegistryObject;

public enum Matter {
    BASIC(0, null, null),
    DARK(2, (Supplier<Item>)PEItems.DARK_MATTER, () -> ((BlockRegistryObject)PEBlocks.DARK_MATTER).getBlock()),
    RED(4, (Supplier<Item>)PEItems.RED_MATTER, () -> ((BlockRegistryObject)PEBlocks.RED_MATTER).getBlock()),
    MAGENTA(4, null, null),
    PINK(5, null, null),
    PURPLE(5, null, null),
    VIOLET(6, null, null),
    BLUE(6, null, null),
    CYAN(7, null, null),
    GREEN(7, null, null),
    LIME(8, null, null),
    YELLOW(8, null, null),
    ORANGE(9, null, null),
    WHITE(9, null, null),
    FADING(10, null, null),
    FINAL(10, (Supplier<Item>)Items.FINAL_STAR_SHARD, null);

    public final BigDecimal BASE_COLLECTOR_OUTPUT = BigDecimal.valueOf(4L);
    public final BigDecimal BASE_RELAY_BONUS = BigDecimal.valueOf(1L);
    public final BigDecimal BASE_RELAY_TRANSFER = BigDecimal.valueOf(64L);
    public static final Matter[] VALUES;
    public final String name;
    public final boolean hasItem;
    public final boolean hasBlock;
    public final int level;
    public final BigDecimal collectorOutputBase;
    public final BigDecimal relayBonusBase;
    public final BigDecimal relayTransferBase;
    @Deprecated
    public final int fluidEfficiency;
    @Nullable
    public final Supplier<Item> existingItem;
    @Nullable
    public final Supplier<Block> existingBlock;
    public final Rarity rarity;
    @Nullable
    private RegistryObject<Item> itemMatter = null;
    @Nullable
    private RegistryObject<BlockPowerFlower> powerFlower = null;
    @Nullable
    private RegistryObject<BlockItem> itemPowerFlower = null;
    @Nullable
    private RegistryObject<BlockCollector> collector = null;
    @Nullable
    private RegistryObject<BlockItem> itemCollector = null;
    @Nullable
    private RegistryObject<ItemCompressedEnergyCollector> itemCompressedCollector = null;
    @Nullable
    private RegistryObject<BlockRelay> relay = null;
    @Nullable
    private RegistryObject<BlockItem> itemRelay = null;
    @Nullable
    private RegistryObject<BlockEMCLink> emcLink = null;
    @Nullable
    private RegistryObject<BlockItem> itemEMCLink = null;
    @Nullable
    private RegistryObject<BlockItem> itemMatterBlock = null;
    @Nullable
    private RegistryObject<Block> blockMatterBlock = null;
    public static final int UNCOMMON_THRESHOLD = 4;
    public static final int RARE_THRESHOLD = 15;
    public static final int EPIC_THRESHOLD = 16;

    public Matter prev() {
        return VALUES[(this.ordinal() - 1 + VALUES.length) % VALUES.length];
    }

    public Matter next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    private Matter(@Nullable int fluidEfficiency, Supplier<Item> existingItem, Supplier<Block> existingBlock) {
        boolean isFinal = this.name().equals("FINAL");
        this.name = this.name().toLowerCase(Locale.US);
        this.hasItem = existingItem == null && this.ordinal() != 0;
        this.hasBlock = existingBlock == null && this.ordinal() != 0 && this.ordinal() != 15;
        this.level = this.ordinal() + 1;
        this.collectorOutputBase = this.getValue(this.BASE_COLLECTOR_OUTPUT);
        this.relayBonusBase = this.getValue(this.BASE_RELAY_BONUS);
        this.relayTransferBase = isFinal ? BigDecimal.valueOf(Long.MAX_VALUE) : this.getValue(this.BASE_RELAY_TRANSFER);
        this.fluidEfficiency = fluidEfficiency;
        this.existingItem = existingItem;
        this.existingBlock = existingBlock;
        this.rarity = this.level >= 16 ? Rarity.EPIC : (this.level >= 15 ? Rarity.RARE : (this.level >= 4 ? Rarity.UNCOMMON : Rarity.COMMON));
    }

    public int getLevel() {
        return this.level;
    }

    private BigDecimal getValue(BigDecimal base) {
        BigDecimal val = base;
        for (int i = 0; i < this.ordinal(); ++i) {
            val = val.multiply(BigDecimal.valueOf(6L));
        }
        return val;
    }

    public int getFluidEfficiencyPercentage() {
        if (!((Boolean)Config.enableFluidEfficiency.get()).booleanValue()) {
            return 100;
        }
        AtomicInteger efficiency = new AtomicInteger(this.fluidEfficiency);
        Arrays.stream(VALUES).filter(m -> m.level < this.level).forEach(m -> efficiency.addAndGet(m.fluidEfficiency));
        return efficiency.get();
    }

    public BigInteger getPowerFlowerOutput() {
        return this.collectorOutputBase.multiply(BigDecimal.valueOf(18L)).add(this.relayBonusBase.multiply(BigDecimal.valueOf(30L))).multiply(BigDecimal.valueOf((Double)Config.powerflowerMultiplier.get())).toBigInteger();
    }

    public BigInteger getPowerFlowerOutputForTicks(int ticks) {
        if (ticks == 20) {
            return this.getPowerFlowerOutput();
        }
        BigInteger div20 = this.getPowerFlowerOutput().divide(BigInteger.valueOf(20L));
        return div20.multiply(BigInteger.valueOf(ticks));
    }

    public BigInteger getCollectorOutput() {
        return this.collectorOutputBase.multiply(BigDecimal.valueOf((Double)Config.collectorMultiplier.get())).toBigInteger();
    }

    public BigInteger getCollectorOutputForTicks(int ticks) {
        return this.getCollectorOutput();
    }

    public BigInteger getRelayBonus() {
        return this.relayBonusBase.multiply(BigDecimal.valueOf((Double)Config.relayBonusMultiplier.get())).toBigInteger();
    }

    public BigInteger getRelayBonusForTicks(int ticks) {
        return this.getRelayBonus();
    }

    public BigInteger getRelayTransfer() {
        return this.relayTransferBase.multiply(BigDecimal.valueOf((Double)Config.relayTransferMultiplier.get())).toBigInteger();
    }

    public BigInteger getRelayTransferForTicks(int ticks) {
        return this.getRelayTransfer();
    }

    public int getEMCLinkInventorySize() {
        return this.level * 3;
    }

    public BigInteger getEMCLinkEMCLimit() {
        return BigDecimal.valueOf(16L).pow(this.level).multiply(BigDecimal.valueOf((Double)Config.emcLinkEMCLimitMultiplier.get())).toBigInteger();
    }

    public int getEMCLinkItemLimit() {
        try {
            return BigDecimal.valueOf(2L).pow(this.level - 1).multiply(BigDecimal.valueOf((Double)Config.emcLinkItemLimitMultiplier.get())).intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public int getEMCLinkFluidLimit() {
        try {
            return BigDecimal.valueOf(2L).pow(this.level - 1).multiply(BigDecimal.valueOf(1000L)).multiply(BigDecimal.valueOf((Double)Config.emcLinkFluidLimitMultiplier.get())).intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public IFormattableTextComponent getFormattedComponent(int value) {
        return this.getFormattedComponent(BigInteger.valueOf(value));
    }

    public IFormattableTextComponent getFormattedComponent(long value) {
        return this.getFormattedComponent(BigInteger.valueOf(value));
    }

    public IFormattableTextComponent getFormattedComponent(BigInteger value) {
        return (this.equals((Object)FINAL) ? new StringTextComponent("INFINITY") : EMCFormat.getComponent(value)).func_230530_a_(ColorStyle.GREEN);
    }

    public IFormattableTextComponent getEMCLinkItemLimitComponent() {
        return this.getFormattedComponent(this.getEMCLinkItemLimit());
    }

    public IFormattableTextComponent getEMCLinkFluidLimitComponent() {
        return this.getFormattedComponent(this.getEMCLinkFluidLimit());
    }

    public IFormattableTextComponent getEMCLinkEMCLimitComponent() {
        return this.getFormattedComponent(this.getEMCLinkEMCLimit());
    }

    public IFormattableTextComponent getRelayTransferComponent() {
        return this.getFormattedComponent(this.getRelayTransferForTicks((Integer)Config.tickDelay.get()));
    }

    @Nullable
    public Item getMatter() {
        return this.itemMatter == null ? null : (Item)this.itemMatter.get();
    }

    @Nullable
    public BlockPowerFlower getPowerFlower() {
        return this.powerFlower == null ? null : (BlockPowerFlower)this.powerFlower.get();
    }

    @Nullable
    public BlockItem getPowerFlowerItem() {
        return this.itemPowerFlower == null ? null : (BlockItem)this.itemPowerFlower.get();
    }

    @Nullable
    public BlockRelay getRelay() {
        return this.relay == null ? null : (BlockRelay)this.relay.get();
    }

    @Nullable
    public BlockItem getRelayItem() {
        return this.itemRelay == null ? null : (BlockItem)this.itemRelay.get();
    }

    @Nullable
    public BlockCollector getCollector() {
        return this.collector == null ? null : (BlockCollector)this.collector.get();
    }

    @Nullable
    public BlockItem getCollectorItem() {
        return this.itemCollector == null ? null : (BlockItem)this.itemCollector.get();
    }

    @Nullable
    public ItemCompressedEnergyCollector getCompressedCollectorItem() {
        return this.itemCompressedCollector == null ? null : (ItemCompressedEnergyCollector)this.itemCompressedCollector.get();
    }

    @Nullable
    public BlockEMCLink getEMCLink() {
        return this.emcLink == null ? null : (BlockEMCLink)this.emcLink.get();
    }

    @Nullable
    public BlockItem getEMCLinkItem() {
        return this.itemEMCLink == null ? null : (BlockItem)this.itemEMCLink.get();
    }

    private void register(RegistrationType reg) {
        switch (reg) {
            case MATTER: {
                if (!this.hasItem) break;
                this.itemMatter = Items.Registry.register(String.format("%s_matter", this.name), () -> new Item(new Item.Properties().func_200916_a(Main.tab).func_208103_a(this.rarity)));
                break;
            }
            case MATTER_BLOCK: {
                if (!this.hasBlock) break;
                this.blockMatterBlock = Blocks.Registry.register(String.format("%s_matter_block", this.name), () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2000000.0f, 6000000.0f).func_235861_h_().func_235838_a_(state -> Math.min(this.ordinal(), 15))));
                this.itemMatterBlock = Items.Registry.register(String.format("%s_matter_block", this.name), () -> new BlockItem((Block)Objects.requireNonNull(this.blockMatterBlock).get(), new Item.Properties().func_200916_a(Main.tab).func_208103_a(this.rarity)));
                break;
            }
            case COLLECTOR: {
                this.collector = Blocks.Registry.register(String.format("%s_collector", this.name), () -> new BlockCollector(this));
                this.itemCollector = Items.Registry.register(String.format("%s_collector", this.name), () -> new BlockItem((Block)Objects.requireNonNull(Objects.requireNonNull(this.collector).get()), new Item.Properties().func_200916_a(Main.tab).func_208103_a(this.rarity)));
                break;
            }
            case COMPRESSED_COLLECTOR: {
                this.itemCompressedCollector = Items.Registry.register(String.format("%s_compressed_collector", this.name), () -> new ItemCompressedEnergyCollector(this));
                break;
            }
            case POWER_FLOWER: {
                this.powerFlower = Blocks.Registry.register(String.format("%s_power_flower", this.name), () -> new BlockPowerFlower(this));
                this.itemPowerFlower = Items.Registry.register(String.format("%s_power_flower", this.name), () -> new BlockItem((Block)Objects.requireNonNull(Objects.requireNonNull(this.powerFlower).get()), new Item.Properties().func_200916_a(Main.tab).func_208103_a(this.rarity)));
                break;
            }
            case RELAY: {
                this.relay = Blocks.Registry.register(String.format("%s_relay", this.name), () -> new BlockRelay(this));
                this.itemRelay = Items.Registry.register(String.format("%s_relay", this.name), () -> new BlockItem((Block)Objects.requireNonNull(Objects.requireNonNull(this.relay).get()), new Item.Properties().func_200916_a(Main.tab).func_208103_a(this.rarity)));
                break;
            }
            case EMC_LINK: {
                this.emcLink = Blocks.Registry.register(String.format("%s_emc_link", this.name), () -> new BlockEMCLink(this));
                this.itemEMCLink = Items.Registry.register(String.format("%s_emc_link", this.name), () -> new BlockItem((Block)Objects.requireNonNull(Objects.requireNonNull(this.emcLink).get()), new Item.Properties().func_200916_a(Main.tab).func_208103_a(this.rarity)));
            }
        }
    }

    public static void registerAll() {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.register((RegistrationType)((Object)type))));
    }

    static {
        VALUES = Matter.values();
    }

    private static enum RegistrationType {
        MATTER,
        MATTER_BLOCK,
        COLLECTOR,
        COMPRESSED_COLLECTOR,
        POWER_FLOWER,
        RELAY,
        EMC_LINK;

    }
}

