/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.item.FuelBlockItem;
import cool.furry.mc.forge.projectexpansion.item.ItemFuel;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.items.AlchemicalFuel;
import moze_intel.projecte.gameObjs.registration.impl.ItemRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;

public enum Fuel {
    ALCHEMICAL("alchemical", false, 1, () -> ((ItemRegistryObject)PEItems.ALCHEMICAL_COAL).func_199767_j()),
    MOBIUS("mobius", false, 2, () -> ((ItemRegistryObject)PEItems.MOBIUS_FUEL).func_199767_j()),
    AETERNALIS("aeternalis", false, 3, () -> ((ItemRegistryObject)PEItems.AETERNALIS_FUEL).func_199767_j()),
    MAGENTA("magenta", true, 4, null),
    PINK("pink", true, 5, null),
    PURPLE("purple", true, 6, null),
    VIOLET("violet", true, 7, null),
    BLUE("blue", true, 8, null),
    CYAN("cyan", true, 9, null),
    GREEN("green", true, 10, null),
    LIME("lime", true, 11, null),
    YELLOW("yellow", true, 12, null),
    ORANGE("orange", true, 13, null),
    WHITE("white", true, 14, null);

    public static final int UNCOMMON_THRESHOLD = 4;
    public static final int RARE_THRESHOLD = 15;
    public static final int EPIC_THRESHOLD = 16;
    public static final Fuel[] VALUES;
    public final String name;
    public final boolean hasItem;
    public final int level;
    @Nullable
    public final Supplier<Item> existingItem;
    public final Rarity rarity;
    @Nullable
    private RegistryObject<Item> item = null;
    @Nullable
    private RegistryObject<Block> block = null;
    @Nullable
    private RegistryObject<BlockItem> blockItem = null;

    private Fuel(String name, @Nullable boolean hasItem, int level, Supplier<Item> existingItem) {
        this.name = name;
        this.hasItem = hasItem;
        this.level = level;
        this.existingItem = existingItem;
        this.rarity = level >= 16 ? Rarity.EPIC : (level >= 15 ? Rarity.RARE : (level >= 4 ? Rarity.UNCOMMON : Rarity.COMMON));
    }

    public int getBurnTime() {
        return this.item == null ? -1 : ((AlchemicalFuel)PEItems.AETERNALIS_FUEL.get()).getBurnTime(new ItemStack((IItemProvider)this.item.get()));
    }

    @Nullable
    public Item getItem() {
        return this.item == null ? null : (Item)this.item.get();
    }

    @Nullable
    public Block getBlock() {
        return this.block == null ? null : (Block)this.block.get();
    }

    @Nullable
    public BlockItem getBlockItem() {
        return this.blockItem == null ? null : (BlockItem)this.blockItem.get();
    }

    private void register(RegistrationType reg) {
        if (!this.hasItem) {
            return;
        }
        switch (reg) {
            case ITEM: {
                this.item = Items.Registry.register(String.format("%s_fuel", this.name), () -> new ItemFuel(this));
                break;
            }
            case BLOCK: {
                this.block = Blocks.Registry.register(String.format("%s_fuel_block", this.name), () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(0.5f, 1.5f)));
                this.blockItem = Items.Registry.register(String.format("%s_fuel_block", this.name), () -> new FuelBlockItem(this));
            }
        }
    }

    public static void registerAll() {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.register((RegistrationType)((Object)type))));
    }

    static {
        VALUES = Fuel.values();
    }

    private static enum RegistrationType {
        ITEM,
        BLOCK;

    }
}

