/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.block.BlockAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import cool.furry.mc.forge.projectexpansion.registries.TileEntityTypes;
import cool.furry.mc.forge.projectexpansion.tile.TileAdvancedAlchemicalChest;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;

public class AdvancedAlchemicalChest {
    private static final Map<DyeColor, RegistryObject<BlockAdvancedAlchemicalChest>> blocks = new HashMap<DyeColor, RegistryObject<BlockAdvancedAlchemicalChest>>();
    private static final Map<DyeColor, RegistryObject<TileEntityType<TileAdvancedAlchemicalChest>>> blockEntityTypes = new HashMap<DyeColor, RegistryObject<TileEntityType<TileAdvancedAlchemicalChest>>>();
    private static final Map<DyeColor, RegistryObject<BlockItem>> blockItems = new HashMap<DyeColor, RegistryObject<BlockItem>>();

    public static void register() {
        for (DyeColor color : DyeColor.values()) {
            blocks.put(color, (RegistryObject<BlockAdvancedAlchemicalChest>)Blocks.Registry.register(String.format("%s_advanced_alchemical_chest", color.func_176762_d()), () -> new BlockAdvancedAlchemicalChest(color)));
            blockItems.put(color, (RegistryObject<BlockItem>)Items.Registry.register(String.format("%s_advanced_alchemical_chest", color.func_176762_d()), () -> new BlockItem((Block)AdvancedAlchemicalChest.getBlock(color), new Item.Properties().func_200916_a(Main.tab))));
            blockEntityTypes.put(color, (RegistryObject<TileEntityType<TileAdvancedAlchemicalChest>>)TileEntityTypes.Registry.register(String.format("%s_advanced_alchemical_chest", color.func_176762_d()), () -> TileEntityType.Builder.func_223042_a(() -> new TileAdvancedAlchemicalChest(AdvancedAlchemicalChest.getBlockEntityType(color), color), (Block[])new Block[]{AdvancedAlchemicalChest.getBlock(color)}).func_206865_a(null)));
        }
    }

    public static RegistryObject<BlockAdvancedAlchemicalChest> getRegistryBlock(DyeColor color) {
        return blocks.get(color);
    }

    public static BlockAdvancedAlchemicalChest getBlock(DyeColor color) {
        return (BlockAdvancedAlchemicalChest)AdvancedAlchemicalChest.getRegistryBlock(color).get();
    }

    public static RegistryObject<TileEntityType<TileAdvancedAlchemicalChest>> getRegistryBlockEntityType(DyeColor color) {
        return blockEntityTypes.get(color);
    }

    public static TileEntityType<TileAdvancedAlchemicalChest> getBlockEntityType(DyeColor color) {
        return (TileEntityType)AdvancedAlchemicalChest.getRegistryBlockEntityType(color).get();
    }

    public static BlockAdvancedAlchemicalChest[] getBlocks() {
        return (BlockAdvancedAlchemicalChest[])blocks.values().stream().map(RegistryObject::get).toArray(BlockAdvancedAlchemicalChest[]::new);
    }
}

