/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.tile;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.TileEntityTypes;
import cool.furry.mc.forge.projectexpansion.tile.TileNBTFilterable;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileTransmutationInterface
extends TileNBTFilterable
implements ITickableTileEntity {
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(() -> new ItemHandler());
    private ItemInfo[] info;

    public TileTransmutationInterface() {
        super((TileEntityType)TileEntityTypes.TRANSMUTATION_INTERFACE.get());
    }

    private ItemInfo[] fetchKnowledge() {
        if (this.info != null) {
            return this.info;
        }
        IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
        if (provider == null) {
            return new ItemInfo[0];
        }
        this.info = provider.getKnowledge().toArray(new ItemInfo[0]);
        return this.info;
    }

    private int getMaxCount(int slot) {
        IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
        if (provider == null) {
            return 0;
        }
        BigInteger playerEmc = provider.getEmc();
        if (playerEmc.compareTo(BigInteger.ZERO) < 1) {
            return 0;
        }
        BigInteger targetItemEmc = BigInteger.valueOf(ProjectEAPI.getEMCProxy().getValue(this.fetchKnowledge()[slot]));
        if (targetItemEmc.compareTo(BigInteger.ZERO) < 1) {
            return 0;
        }
        return playerEmc.divide(targetItemEmc).min(BigInteger.valueOf(Math.max(1, (Integer)Config.transmutationInterfaceItemCount.get()))).intValue();
    }

    public void func_73660_a() {
        this.info = null;
    }

    ItemHandler getItemHandlerCapability() {
        return (ItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHandlerCapability.cast() : super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.itemHandlerCapability.invalidate();
    }

    class ItemHandler
    implements IItemHandler {
        ItemHandler() {
        }

        public int getSlots() {
            return TileTransmutationInterface.this.fetchKnowledge().length + 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (TileTransmutationInterface.this.owner == null || Util.getPlayer(TileTransmutationInterface.this.owner) == null) {
                return ItemStack.field_190927_a;
            }
            TileTransmutationInterface.this.fetchKnowledge();
            if (slot <= 0 || TileTransmutationInterface.this.fetchKnowledge().length < slot) {
                return ItemStack.field_190927_a;
            }
            int maxCount = TileTransmutationInterface.this.getMaxCount(slot - 1);
            if (maxCount <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack item = TileTransmutationInterface.this.fetchKnowledge()[slot - 1].createStack();
            item.func_190920_e(maxCount);
            return item;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot != 0 || TileTransmutationInterface.this.owner == null || !this.isItemValid(slot, stack) || stack.func_190926_b() || Util.getPlayer(TileTransmutationInterface.this.owner) == null) {
                return stack;
            }
            TileTransmutationInterface.this.fetchKnowledge();
            ItemInfo info = ItemInfo.fromStack((ItemStack)stack);
            int count = stack.func_190916_E();
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            if (count <= 0) {
                return stack;
            }
            if (TileTransmutationInterface.this.getFilterStatus() && !NBTManager.getPersistentInfo((ItemInfo)info).equals((Object)info)) {
                return stack;
            }
            if (simulate) {
                return ItemStack.field_190927_a;
            }
            long emcValue = ProjectEAPI.getEMCProxy().getSellValue(stack);
            IKnowledgeProvider provider = Util.getKnowledgeProvider(TileTransmutationInterface.this.owner);
            if (provider == null) {
                return stack;
            }
            BigInteger totalEmcValue = BigInteger.valueOf(emcValue).multiply(BigInteger.valueOf(count));
            provider.setEmc(provider.getEmc().add(totalEmcValue));
            ServerPlayerEntity player = Util.getPlayer(TileTransmutationInterface.this.field_145850_b, TileTransmutationInterface.this.owner);
            if (player != null) {
                if (provider.addKnowledge(stack)) {
                    provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)info), true);
                }
                provider.syncEmc(player);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot <= 0 || TileTransmutationInterface.this.owner == null || TileTransmutationInterface.this.fetchKnowledge().length < slot || Util.getPlayer(TileTransmutationInterface.this.owner) == null) {
                return ItemStack.field_190927_a;
            }
            TileTransmutationInterface.this.fetchKnowledge();
            amount = Math.min(amount, TileTransmutationInterface.this.getMaxCount(slot - 1));
            if (amount <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack item = TileTransmutationInterface.this.fetchKnowledge()[slot - 1].createStack();
            item.func_190920_e(amount);
            if (simulate) {
                return item;
            }
            long emcValue = ProjectEAPI.getEMCProxy().getValue(TileTransmutationInterface.this.fetchKnowledge()[slot - 1]);
            BigInteger totalEmcCost = BigInteger.valueOf(emcValue).multiply(BigInteger.valueOf(amount));
            IKnowledgeProvider provider = Util.getKnowledgeProvider(TileTransmutationInterface.this.owner);
            if (provider == null) {
                return ItemStack.field_190927_a;
            }
            provider.setEmc(provider.getEmc().subtract(totalEmcCost));
            ServerPlayerEntity player = Util.getPlayer(TileTransmutationInterface.this.field_145850_b, TileTransmutationInterface.this.owner);
            if (player != null) {
                provider.syncEmc(player);
            }
            return item;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ProjectEAPI.getEMCProxy().hasValue(stack);
        }
    }
}

