/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.tile;

import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TileOwnable
extends TileEntity {
    public UUID owner = new UUID(0L, 0L);
    public String ownerName = "";

    public TileOwnable(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_186855_b(NBTNames.OWNER)) {
            this.owner = nbt.func_186857_a(NBTNames.OWNER);
        }
        if (nbt.func_150297_b(NBTNames.OWNER_NAME, 8)) {
            this.ownerName = nbt.func_74779_i(NBTNames.OWNER_NAME);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_186854_a(NBTNames.OWNER, this.owner);
        nbt.func_74778_a(NBTNames.OWNER_NAME, this.ownerName);
        return nbt;
    }

    public void setOwner(PlayerEntity player) {
        this.owner = player.func_110124_au();
        this.ownerName = player.func_195047_I_();
        Util.markDirty(this);
    }

    public boolean handleActivation(PlayerEntity player, ActivationType activationType) {
        switch (activationType) {
            case DISPLAY_NAME: {
                player.func_146105_b((ITextComponent)new StringTextComponent(this.ownerName), true);
                break;
            }
            case CHECK_OWNERSHIP: {
                if (this.owner.equals(player.func_110124_au())) break;
                player.func_146105_b((ITextComponent)Lang.NOT_OWNER.translateColored(TextFormatting.RED, new Object[]{new StringTextComponent(this.ownerName).func_230530_a_(ColorStyle.RED)}), true);
                return false;
            }
        }
        return true;
    }

    public void handlePlace(@Nullable LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity) {
            this.setOwner((PlayerEntity)livingEntity);
        }
    }

    public static enum ActivationType {
        DISPLAY_NAME,
        CHECK_OWNERSHIP;

    }
}

