/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.tile;

import cool.furry.mc.forge.projectexpansion.block.BlockEMCLink;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.TileEntityTypes;
import cool.furry.mc.forge.projectexpansion.tile.TileNBTFilterable;
import cool.furry.mc.forge.projectexpansion.tile.TileOwnable;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEMCLink
extends TileNBTFilterable
implements ITickableTileEntity,
IHasMatter {
    private final LazyOptional<IEmcStorage> emcStorageCapability = LazyOptional.of(() -> new EMCHandler());
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(() -> new ItemHandler());
    private final LazyOptional<IFluidHandler> fluidHandlerCapability = LazyOptional.of(() -> new FluidHandler());
    public BigInteger emc = BigInteger.ZERO;
    public ItemStack itemStack;
    public Matter matter;
    public BigInteger remainingEMC = BigInteger.ZERO;
    public int remainingImport = 0;
    public int remainingExport = 0;
    public int remainingFluid = 0;

    public TileEMCLink() {
        super((TileEntityType)TileEntityTypes.EMC_LINK.get());
        this.itemStack = ItemStack.field_190927_a;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b(NBTNames.STORED_EMC, 8)) {
            this.emc = new BigInteger(nbt.func_74779_i(NBTNames.STORED_EMC));
        }
        if (nbt.func_150297_b(NBTNames.ITEM, 10)) {
            this.itemStack = NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(NBTNames.ITEM)))).createStack();
        }
        if (nbt.func_150297_b(NBTNames.REMAINING_EMC, 8)) {
            this.remainingEMC = new BigInteger(nbt.func_74779_i(NBTNames.REMAINING_EMC));
        }
        if (nbt.func_150297_b(NBTNames.REMAINING_IMPORT, 3)) {
            this.remainingImport = nbt.func_74762_e(NBTNames.REMAINING_IMPORT);
        }
        if (nbt.func_150297_b(NBTNames.REMAINING_EXPORT, 3)) {
            this.remainingExport = nbt.func_74762_e(NBTNames.REMAINING_EXPORT);
        }
        if (nbt.func_150297_b(NBTNames.REMAINING_FLUID, 3)) {
            this.remainingFluid = nbt.func_74762_e(NBTNames.REMAINING_FLUID);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a(NBTNames.STORED_EMC, this.emc.toString());
        nbt.func_218657_a(NBTNames.ITEM, (INBT)this.itemStack.serializeNBT());
        nbt.func_74778_a(NBTNames.REMAINING_EMC, this.remainingEMC.toString());
        nbt.func_74768_a(NBTNames.REMAINING_IMPORT, this.remainingImport);
        nbt.func_74768_a(NBTNames.REMAINING_EXPORT, this.remainingExport);
        nbt.func_74768_a(NBTNames.REMAINING_FLUID, this.remainingFluid);
        return nbt;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != (long)Util.mod(this.hashCode(), 20)) {
            return;
        }
        this.resetLimits();
        if (this.emc.equals(BigInteger.ZERO)) {
            return;
        }
        ServerPlayerEntity player = Util.getPlayer(this.field_145850_b, this.owner);
        IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
        if (provider == null) {
            return;
        }
        BigInteger toAdd = this.getMatter() == Matter.FINAL ? this.emc : this.remainingEMC.min(this.emc);
        provider.setEmc(provider.getEmc().add(toAdd));
        this.emc = this.emc.subtract(toAdd).max(BigInteger.ZERO);
        if (player != null) {
            provider.syncEmc(player);
        }
        Util.markDirty(this);
    }

    private void resetLimits() {
        Matter m = this.getMatter();
        this.remainingEMC = m.getEMCLinkEMCLimit();
        this.remainingImport = this.remainingExport = m.getEMCLinkItemLimit();
        this.remainingFluid = m.getEMCLinkFluidLimit();
    }

    private void setInternalItem(ItemStack stack) {
        this.itemStack = NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1))).createStack();
        Util.markDirty(this);
    }

    @Override
    public void handlePlace(@Nullable LivingEntity livingEntity, ItemStack stack) {
        super.handlePlace(livingEntity, stack);
        this.resetLimits();
    }

    @Override
    @Nonnull
    public Matter getMatter() {
        if (this.field_145850_b != null) {
            BlockEMCLink block = (BlockEMCLink)this.func_195044_w().func_177230_c();
            if (block.getMatter() != this.matter) {
                this.setMatter(block.getMatter());
            }
            return this.matter;
        }
        return Matter.BASIC;
    }

    private void setMatter(Matter matter) {
        this.matter = matter;
    }

    EMCHandler getEMCHandlerCapability() {
        return (EMCHandler)this.getCapability(ProjectEAPI.EMC_STORAGE_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    ItemHandler getItemHandlerCapability() {
        return (ItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    FluidHandler getFluidHandlerCapability() {
        return (FluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public ActionResultType handleActivation(PlayerEntity player, Hand hand) {
        ItemStack inHand = player.func_184586_b(hand);
        ItemHandler itemHandler = this.getItemHandlerCapability();
        FluidHandler fluidHandler = this.getFluidHandlerCapability();
        if (!super.handleActivation(player, TileOwnable.ActivationType.CHECK_OWNERSHIP)) {
            return ActionResultType.CONSUME;
        }
        if (player.func_213453_ef()) {
            if (this.itemStack.func_190926_b()) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_NOT_SET.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.CONSUME;
            }
            if (inHand.func_190926_b()) {
                this.setInternalItem(ItemStack.field_190927_a);
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_CLEARED.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.SUCCESS;
            }
        }
        if (this.itemStack.func_190926_b()) {
            if (inHand.func_190926_b()) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_NOT_SET.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.CONSUME;
            }
            if (!itemHandler.isItemValid(0, inHand)) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_EMPTY_HAND.translateColored(TextFormatting.RED, new Object[]{new StringTextComponent(this.itemStack.func_77973_b().toString()).func_230530_a_(ColorStyle.BLUE)}), true);
                return ActionResultType.CONSUME;
            }
            this.setInternalItem(inHand);
            player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_SET.translateColored(TextFormatting.GREEN, new Object[]{new StringTextComponent(this.itemStack.func_77973_b().toString()).func_230530_a_(ColorStyle.BLUE)}), true);
            return ActionResultType.SUCCESS;
        }
        Fluid fluid = fluidHandler.getFluid();
        if (fluid != null && fluidHandler.isValid() && inHand.func_77973_b() instanceof BucketItem && ((BucketItem)inHand.func_77973_b()).getFluid() == Fluids.field_204541_a) {
            BucketItem bucketItem = (BucketItem)inHand.func_77973_b();
            if (((Boolean)Config.limitEmcLinkVendor.get()).booleanValue() && this.remainingFluid < 1000) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_NO_EXPORT_REMAINING.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.CONSUME;
            }
            long cost = fluidHandler.getFluidCost(1000.0);
            IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
            if (provider == null) {
                player.func_146105_b((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{Util.getPlayer(this.owner) == null ? this.owner : Objects.requireNonNull(Util.getPlayer(this.owner)).func_145748_c_()}), true);
                return ActionResultType.FAIL;
            }
            BigInteger emc = provider.getEmc();
            if (emc.compareTo(BigInteger.valueOf(cost)) < 0) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_NOT_ENOUGH_EMC.translateColored(TextFormatting.RED, new Object[]{new StringTextComponent(EMCFormat.format(BigInteger.valueOf(ProjectEAPI.getEMCProxy().getValue(this.itemStack)))).func_230530_a_(ColorStyle.GREEN)}), true);
                return ActionResultType.CONSUME;
            }
            FluidActionResult fillResult = FluidUtil.tryFillContainer((ItemStack)inHand, (IFluidHandler)fluidHandler, (int)1000, (PlayerEntity)player, (boolean)true);
            if (!fillResult.isSuccess()) {
                return ActionResultType.FAIL;
            }
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)fillResult.getResult());
            provider.setEmc(emc.subtract(BigInteger.valueOf(cost)));
            this.remainingFluid -= 1000;
            Util.markDirty(this);
            if (player instanceof ServerPlayerEntity) {
                provider.syncEmc((ServerPlayerEntity)player);
            }
            return ActionResultType.CONSUME;
        }
        if (inHand.func_190926_b() || this.itemStack.equals(inHand)) {
            if (((Boolean)Config.limitEmcLinkVendor.get()).booleanValue() && this.remainingExport <= 0) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_NO_EXPORT_REMAINING.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.CONSUME;
            }
            ItemStack extract = itemHandler.extractItemInternal(0, this.itemStack.func_77976_d(), false, (Boolean)Config.limitEmcLinkVendor.get());
            if (extract.func_190926_b()) {
                player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_NOT_ENOUGH_EMC.translateColored(TextFormatting.RED, new Object[]{new StringTextComponent(EMCFormat.format(BigInteger.valueOf(ProjectEAPI.getEMCProxy().getValue(this.itemStack)))).func_230530_a_(ColorStyle.GREEN)}), true);
                return ActionResultType.CONSUME;
            }
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)extract);
            return ActionResultType.SUCCESS;
        }
        player.func_146105_b((ITextComponent)Lang.Blocks.EMC_LINK_EMPTY_HAND.translateColored(TextFormatting.RED, new Object[0]), true);
        return ActionResultType.CONSUME;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ProjectEAPI.EMC_STORAGE_CAPABILITY ? this.emcStorageCapability.cast() : (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHandlerCapability.cast() : (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.fluidHandlerCapability.cast() : super.getCapability(cap, side)));
    }

    protected void invalidateCaps() {
        this.emcStorageCapability.invalidate();
        this.itemHandlerCapability.invalidate();
        this.fluidHandlerCapability.invalidate();
    }

    class FluidHandler
    implements IFluidHandler {
        FluidHandler() {
        }

        @Nullable
        public Fluid getFluid() {
            if (!TileEMCLink.this.itemStack.func_190926_b() && TileEMCLink.this.itemStack.func_77973_b() instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)TileEMCLink.this.itemStack.func_77973_b();
                return bucketItem.getFluid();
            }
            return null;
        }

        private double getFluidCostPer() {
            try {
                long fullCost = ProjectEAPI.getEMCProxy().getValue(TileEMCLink.this.itemStack);
                long bucketCost = ProjectEAPI.getEMCProxy().getValue(Items.field_151133_ar);
                if (bucketCost == 0L && fullCost == 0L) {
                    return 0.0;
                }
                return (double)((float)fullCost - (float)(bucketCost * (long)TileEMCLink.this.getMatter().getFluidEfficiencyPercentage()) / 100.0f) / 1000.0;
            }
            catch (ArithmeticException ignore) {
                return 9.223372036854776E18;
            }
        }

        private boolean isFreeFluid() {
            return this.getFluidCostPer() == 0.0 && (Boolean)Config.zeroEmcFluidsAreFree.get() != false;
        }

        private boolean isValid() {
            return this.getFluid() != null && (this.getFluidCostPer() != 0.0 || this.isFreeFluid());
        }

        private long getFluidCost(double amount) {
            try {
                double cost = this.getFluidCostPer();
                return (long)Math.ceil(cost * amount);
            }
            catch (ArithmeticException ignore) {
                return Long.MAX_VALUE;
            }
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank != 0) {
                return FluidStack.EMPTY;
            }
            Fluid fluid = this.getFluid();
            if (fluid == null || !this.isValid()) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(fluid, TileEMCLink.this.remainingFluid);
        }

        public int getTankCapacity(int tank) {
            if (tank != 0) {
                return 0;
            }
            return TileEMCLink.this.remainingFluid;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            Fluid fluid = this.getFluid();
            if (fluid == null || !this.isValid() || !resource.getFluid().equals(fluid)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            boolean isFinal = TileEMCLink.this.getMatter() == Matter.FINAL;
            Fluid fluid = this.getFluid();
            if (fluid == null || !this.isValid() || Util.getPlayer(TileEMCLink.this.owner) == null) {
                return FluidStack.EMPTY;
            }
            if (!isFinal && maxDrain > TileEMCLink.this.remainingFluid) {
                maxDrain = TileEMCLink.this.remainingFluid;
            }
            long cost = this.getFluidCost(maxDrain);
            IKnowledgeProvider provider = Util.getKnowledgeProvider(TileEMCLink.this.owner);
            if (provider == null) {
                return FluidStack.EMPTY;
            }
            BigInteger emc = provider.getEmc();
            BigDecimal dEMC = new BigDecimal(emc);
            if (dEMC.compareTo(BigDecimal.valueOf(this.getFluidCostPer())) < 0) {
                return FluidStack.EMPTY;
            }
            if (emc.compareTo(BigInteger.valueOf(cost)) < 0) {
                BigDecimal max = dEMC.divide(BigDecimal.valueOf(this.getFluidCostPer()), RoundingMode.FLOOR);
                maxDrain = Util.safeIntValue(max);
                if (!isFinal && maxDrain > TileEMCLink.this.remainingFluid) {
                    maxDrain = TileEMCLink.this.remainingFluid;
                }
                if (maxDrain < 1) {
                    return FluidStack.EMPTY;
                }
                cost = this.getFluidCost(maxDrain);
            }
            if (action.execute()) {
                if (!isFinal) {
                    TileEMCLink.this.remainingFluid -= maxDrain;
                }
                Util.markDirty(TileEMCLink.this);
                if (!this.isFreeFluid()) {
                    provider.setEmc(emc.subtract(BigInteger.valueOf(cost)));
                    provider.syncEmc(Objects.requireNonNull(Util.getPlayer(TileEMCLink.this.owner)));
                }
            }
            return new FluidStack(fluid, maxDrain);
        }
    }

    class ItemHandler
    implements IItemHandler {
        ItemHandler() {
        }

        public int getSlots() {
            return TileEMCLink.this.getMatter().getEMCLinkInventorySize();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot != 0 || TileEMCLink.this.itemStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            IKnowledgeProvider provider = Util.getKnowledgeProvider(TileEMCLink.this.owner);
            if (provider == null) {
                return ItemStack.field_190927_a;
            }
            BigInteger val = BigInteger.valueOf(ProjectEAPI.getEMCProxy().getValue(TileEMCLink.this.itemStack));
            if (val.equals(BigInteger.ZERO)) {
                return ItemStack.field_190927_a;
            }
            BigInteger maxCount = provider.getEmc().divide(val).min(BigInteger.valueOf(Integer.MAX_VALUE));
            int count = maxCount.intValueExact();
            if (count <= 0) {
                return ItemStack.field_190927_a;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)TileEMCLink.this.itemStack, (int)count);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int insertCount;
            boolean isFinal;
            boolean bl = isFinal = TileEMCLink.this.getMatter() == Matter.FINAL;
            if (slot == 0 || !isFinal && TileEMCLink.this.remainingImport <= 0 || TileEMCLink.this.owner == null || stack.func_190926_b() || !this.isItemValid(slot, stack) || Util.getPlayer(TileEMCLink.this.owner) == null) {
                return stack;
            }
            int count = stack.func_190916_E();
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            if (count <= 0) {
                return stack;
            }
            ItemInfo info = ItemInfo.fromStack((ItemStack)stack);
            if (TileEMCLink.this.getFilterStatus() && !NBTManager.getPersistentInfo((ItemInfo)info).equals((Object)info)) {
                return stack;
            }
            int n = insertCount = isFinal ? count : Math.min(count, TileEMCLink.this.remainingImport);
            if (!simulate) {
                long itemValue = ProjectEAPI.getEMCProxy().getSellValue(stack);
                IKnowledgeProvider provider = Util.getKnowledgeProvider(TileEMCLink.this.owner);
                if (provider == null) {
                    return stack;
                }
                BigInteger totalValue = BigInteger.valueOf(itemValue).multiply(BigInteger.valueOf(insertCount));
                provider.setEmc(provider.getEmc().add(totalValue));
                ServerPlayerEntity player = Util.getPlayer(TileEMCLink.this.owner);
                if (player != null) {
                    if (provider.addKnowledge(stack)) {
                        provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)info), true);
                    }
                    provider.syncEmc(player);
                }
                if (!isFinal) {
                    TileEMCLink.this.remainingImport -= insertCount;
                }
                Util.markDirty(TileEMCLink.this);
            }
            if (insertCount == count) {
                return ItemStack.field_190927_a;
            }
            stack.func_190920_e(count - insertCount);
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extractItemInternal(slot, amount, simulate, true);
        }

        public ItemStack extractItemInternal(int slot, int amount, boolean simulate, boolean limit) {
            boolean isFinal;
            boolean bl = isFinal = TileEMCLink.this.getMatter() == Matter.FINAL;
            if (slot != 0 || !isFinal && TileEMCLink.this.remainingExport <= 0 || TileEMCLink.this.owner == null || TileEMCLink.this.itemStack.func_190926_b() || Util.getPlayer(TileEMCLink.this.owner) == null) {
                return ItemStack.field_190927_a;
            }
            BigInteger itemValue = BigInteger.valueOf(ProjectEAPI.getEMCProxy().getValue(TileEMCLink.this.itemStack));
            if (itemValue.equals(BigInteger.ZERO)) {
                return ItemStack.field_190927_a;
            }
            IKnowledgeProvider provider = Util.getKnowledgeProvider(TileEMCLink.this.owner);
            if (provider == null) {
                return ItemStack.field_190927_a;
            }
            BigInteger maxCount = provider.getEmc().divide(itemValue).min(BigInteger.valueOf(Integer.MAX_VALUE));
            int extractCount = Math.min(amount, limit && !isFinal ? Math.min(maxCount.intValueExact(), TileEMCLink.this.remainingExport) : maxCount.intValueExact());
            if (extractCount <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack r = NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)TileEMCLink.this.itemStack.func_77946_l())).createStack();
            r.func_190920_e(extractCount);
            if (simulate) {
                return r;
            }
            BigInteger totalPrice = itemValue.multiply(BigInteger.valueOf(extractCount));
            provider.setEmc(provider.getEmc().subtract(totalPrice));
            ServerPlayerEntity player = Util.getPlayer(TileEMCLink.this.owner);
            if (player != null) {
                provider.syncEmc(player);
            }
            if (limit && !isFinal) {
                TileEMCLink.this.remainingExport -= extractCount;
            }
            Util.markDirty(TileEMCLink.this);
            return r;
        }

        public int getSlotLimit(int slot) {
            return TileEMCLink.this.getMatter().getEMCLinkItemLimit();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ProjectEAPI.getEMCProxy().hasValue(stack);
        }
    }

    class EMCHandler
    implements IEmcStorage {
        EMCHandler() {
        }

        public long getStoredEmc() {
            return 0L;
        }

        public long getMaximumEmc() {
            return Util.safeLongValue(TileEMCLink.this.getMatter().getEMCLinkEMCLimit());
        }

        public long extractEmc(long emc, IEmcStorage.EmcAction action) {
            return emc < 0L ? this.insertEmc(-emc, action) : 0L;
        }

        public long insertEmc(long emc, IEmcStorage.EmcAction action) {
            long v;
            boolean isFinal = TileEMCLink.this.getMatter() == Matter.FINAL;
            long l = v = isFinal ? emc : Math.min(Util.safeLongValue(TileEMCLink.this.remainingEMC), emc);
            if (emc <= 0L) {
                return 0L;
            }
            if (action.execute()) {
                if (!isFinal) {
                    TileEMCLink.this.remainingEMC = TileEMCLink.this.remainingEMC.subtract(BigInteger.valueOf(v));
                }
                TileEMCLink.this.emc = TileEMCLink.this.emc.add(BigInteger.valueOf(v));
                Util.markDirty(TileEMCLink.this);
            }
            return v;
        }
    }
}

