/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.tile;

import cool.furry.mc.forge.projectexpansion.block.BlockCollector;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.TileEntityTypes;
import cool.furry.mc.forge.projectexpansion.tile.TileRelay;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileCollector
extends TileEntity
implements ITickableTileEntity,
IHasMatter {
    public BigInteger emc = BigInteger.ZERO;
    public Matter matter;
    public static final Direction[] DIRECTIONS = Direction.values();
    private final LazyOptional<IEmcStorage> emcStorageCapability = LazyOptional.of(() -> new EMCHandler());

    public TileCollector() {
        super((TileEntityType)TileEntityTypes.COLLECTOR.get());
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b(NBTNames.STORED_EMC, 8)) {
            this.emc = new BigInteger(nbt.func_74779_i(NBTNames.STORED_EMC));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a(NBTNames.STORED_EMC, this.emc.toString());
        return nbt;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != (long)Util.mod(this.hashCode(), 20)) {
            return;
        }
        this.emc = this.emc.add(((BlockCollector)this.func_195044_w().func_177230_c()).getMatter().getCollectorOutputForTicks((Integer)Config.tickDelay.get()));
        ArrayList<IEmcStorage> temp = new ArrayList<IEmcStorage>(1);
        for (Direction dir : DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a(dir.func_176730_m()));
            if (tile == null) continue;
            tile.getCapability(ProjectEAPI.EMC_STORAGE_CAPABILITY, dir.func_176734_d()).ifPresent(storage -> {
                if (storage.insertEmc(1L, IEmcStorage.EmcAction.SIMULATE) > 0L) {
                    temp.add((IEmcStorage)storage);
                    if (tile instanceof RelayMK1Tile) {
                        for (int i = 0; i < 20; ++i) {
                            ((RelayMK1Tile)tile).addBonus();
                        }
                    } else if (tile instanceof TileRelay) {
                        ((TileRelay)tile).getEMCHandlerCapability().addBonus();
                    }
                    Util.markDirty(this);
                }
            });
        }
        this.emc = Util.spreadEMC(this.emc, temp);
    }

    @Override
    @Nonnull
    public Matter getMatter() {
        if (this.field_145850_b != null) {
            BlockCollector block = (BlockCollector)this.func_195044_w().func_177230_c();
            if (block.getMatter() != this.matter) {
                this.setMatter(block.getMatter());
            }
            return this.matter;
        }
        return Matter.BASIC;
    }

    private void setMatter(Matter matter) {
        this.matter = matter;
    }

    EMCHandler getEMCHandlerCapability() {
        return (EMCHandler)this.getCapability(ProjectEAPI.EMC_STORAGE_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ProjectEAPI.EMC_STORAGE_CAPABILITY ? this.emcStorageCapability.cast() : super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.emcStorageCapability.invalidate();
    }

    class EMCHandler
    implements IEmcStorage {
        EMCHandler() {
        }

        public long getStoredEmc() {
            return Util.safeLongValue(TileCollector.this.emc);
        }

        public long getMaximumEmc() {
            return Long.MAX_VALUE;
        }

        public long extractEmc(long emc, IEmcStorage.EmcAction action) {
            long change = Math.min(Util.safeLongValue(TileCollector.this.emc), emc);
            if (change < 0L) {
                return this.insertEmc(-change, action);
            }
            if (action.execute()) {
                TileCollector.this.emc = TileCollector.this.emc.subtract(BigInteger.valueOf(change));
                Util.markDirty(TileCollector.this);
            }
            return change;
        }

        public long insertEmc(long l, IEmcStorage.EmcAction emcAction) {
            return 0L;
        }
    }
}

