/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.tile;

import cool.furry.mc.forge.projectexpansion.block.BlockAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.tile.TileOwnable;
import cool.furry.mc.forge.projectexpansion.util.AdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileAdvancedAlchemicalChest
extends TileOwnable
implements IItemHandler,
ITickableTileEntity {
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(this::getBag);
    public final DyeColor color;
    private int ticksSinceSync;
    private float lidAngle;
    private float prevLidAngle;
    public int numPlayersUsing;

    public TileAdvancedAlchemicalChest(TileEntityType<TileAdvancedAlchemicalChest> blockEntityType, DyeColor color) {
        super(blockEntityType);
        this.color = color;
    }

    @Nullable
    public IItemHandler getBag() {
        ServerPlayerEntity player = Util.getPlayer(this.field_145850_b, this.owner);
        if (player == null) {
            return null;
        }
        try {
            return ((IAlchBagProvider)player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).orElseThrow(NullPointerException::new)).getBag(this.color);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public ActionResultType handleActivation(PlayerEntity player, Hand hand) {
        if (!super.handleActivation(player, TileOwnable.ActivationType.CHECK_OWNERSHIP)) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            player.func_146105_b((ITextComponent)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_INVLID_ITEM.translate(new Object[]{this.color.func_176762_d()}), true);
            return ActionResultType.FAIL;
        }
        if (stack.func_77973_b() instanceof AlchemicalBag) {
            AlchemicalBag bag = (AlchemicalBag)stack.func_77973_b();
            if (this.field_145850_b != null) {
                BlockAdvancedAlchemicalChest block = AdvancedAlchemicalChest.getBlock(bag.color);
                TileEntityType<TileAdvancedAlchemicalChest> blockEntityType = AdvancedAlchemicalChest.getBlockEntityType(bag.color);
                TileAdvancedAlchemicalChest newBlockEntity = new TileAdvancedAlchemicalChest(blockEntityType, bag.color);
                newBlockEntity.owner = this.owner;
                newBlockEntity.ownerName = this.ownerName;
                newBlockEntity.func_189515_b(new CompoundNBT());
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J))).func_206870_a((Property)BlockStateProperties.field_208198_y, this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208198_y)));
                this.field_145850_b.func_175713_t(this.field_174879_c);
                this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)newBlockEntity);
                Util.markDirty(this.field_145850_b, this.field_174879_c);
            }
            player.func_146105_b((ITextComponent)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_COLOR_SET.translate(new Object[]{bag.color.func_176762_d()}), true);
        } else {
            player.func_146105_b((ITextComponent)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_INVLID_ITEM.translate(new Object[0]), true);
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHandlerCapability.cast() : super.getCapability(cap, side);
    }

    public int getSlots() {
        IItemHandler bag = this.getBag();
        return bag == null ? 0 : bag.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        IItemHandler bag = this.getBag();
        return bag == null ? ItemStack.field_190927_a : bag.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        IItemHandler bag = this.getBag();
        return bag == null ? stack : bag.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IItemHandler bag = this.getBag();
        return bag == null ? ItemStack.field_190927_a : bag.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        IItemHandler bag = this.getBag();
        return bag == null ? 0 : bag.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        IItemHandler bag = this.getBag();
        return bag != null && bag.isItemValid(slot, stack);
    }

    protected void updateChest() {
        if (this.field_145850_b == null) {
            return;
        }
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float angleIncrement = 0.1f;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += angleIncrement) : (this.lidAngle -= angleIncrement);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            this.updateChest();
        }
    }

    public boolean func_145842_c(int number, int arg) {
        if (number == 1) {
            this.numPlayersUsing = arg;
            return true;
        }
        return super.func_145842_c(number, arg);
    }

    public float getLidAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }
}

