/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net.packets.to_server;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.UUID;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketTeleportToDestination
implements IPacket {
    final String name;
    final PlayerEntity player;
    final Hand hand;

    public PacketTeleportToDestination(String name, PlayerEntity player, Hand hand) {
        this.name = name;
        this.player = player;
        this.hand = hand;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack stack = this.player.func_184586_b(this.hand);
        if (stack.func_77973_b() instanceof ItemAlchemicalBook) {
            ItemAlchemicalBook book = (ItemAlchemicalBook)stack.func_77973_b();
            try {
                IAlchemicalBookLocationsProvider provider = CapabilityAlchemicalBookLocations.from(stack);
                IKnowledgeProvider knowledgeProvider = (IKnowledgeProvider)this.player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).orElseThrow(() -> new IllegalStateException("Player does not have knowledge capability"));
                BigInteger emc = knowledgeProvider.getEmc();
                CapabilityAlchemicalBookLocations.TeleportLocation location = provider.getLocationOrThrow(this.name);
                BigInteger cost = BigInteger.valueOf(location.getCost(stack, this.player));
                if (!cost.equals(BigInteger.ZERO)) {
                    if (emc.compareTo(cost) < 0) {
                        throw new CapabilityAlchemicalBookLocations.BookError.NotEnoughEMCError(cost.toString());
                    }
                    knowledgeProvider.setEmc(emc.subtract(cost));
                    knowledgeProvider.syncEmc((ServerPlayerEntity)this.player);
                }
                GlobalPos pos = GlobalPos.func_239648_a_((RegistryKey)this.player.field_70170_p.func_234923_W_(), (BlockPos)this.player.func_226268_ag_());
                location.teleportTo((ServerPlayerEntity)this.player, book.getTier().isAcrossDimensions());
                if (location.distanceFrom(pos.func_218180_b()) > 1.0) {
                    provider.saveBackLocation(this.player, pos);
                }
            }
            catch (CapabilityAlchemicalBookLocations.BookError error) {
                Util.sendSystemMessage(this.player, (ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TELEPORT_FAILED.translateColored(TextFormatting.RED, new Object[]{error.getComponent()}));
            }
            catch (IllegalStateException error) {
                Util.sendSystemMessage(this.player, (ITextComponent)Lang.PROVIDER_ERROR.translateColored(TextFormatting.RED, new Object[0]));
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.name);
        buf.func_179252_a(this.player.func_110124_au());
        buf.func_179249_a((Enum)this.hand);
    }

    public static PacketTeleportToDestination decode(PacketBuffer buf) {
        String name = buf.func_218666_n();
        UUID uuid = buf.func_179253_g();
        Hand hand = (Hand)buf.func_179257_a(Hand.class);
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            throw new IllegalStateException("Player not found in PacketTeleportToDestination packet");
        }
        return new PacketTeleportToDestination(name, (PlayerEntity)player, hand);
    }
}

