/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net.packets.to_server;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketTeleportBack
implements IPacket {
    final PlayerEntity player;
    final Hand hand;

    public PacketTeleportBack(PlayerEntity player, Hand hand) {
        this.player = player;
        this.hand = hand;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack stack = this.player.func_184586_b(this.hand);
        if (stack.func_77973_b() instanceof ItemAlchemicalBook) {
            ItemAlchemicalBook book = (ItemAlchemicalBook)stack.func_77973_b();
            try {
                IAlchemicalBookLocationsProvider provider = CapabilityAlchemicalBookLocations.from(stack);
                provider.teleportBack((ServerPlayerEntity)this.player, book.getTier().isAcrossDimensions());
                provider.syncToOtherPlayers();
            }
            catch (CapabilityAlchemicalBookLocations.BookError error) {
                Util.sendSystemMessage(this.player, (ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TELEPORT_FAILED.translateColored(TextFormatting.RED, new Object[]{error.getComponent()}));
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.player.func_110124_au());
        buf.func_179249_a((Enum)this.hand);
    }

    public static PacketTeleportBack decode(PacketBuffer buf) {
        UUID uuid = buf.func_179253_g();
        Hand hand = (Hand)buf.func_179257_a(Hand.class);
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            throw new IllegalStateException("Player not found in PacketTeleportBack packet");
        }
        return new PacketTeleportBack((PlayerEntity)player, hand);
    }
}

