/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net.packets.to_server;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketDeleteTeleportDestination
implements IPacket {
    final String name;
    final PlayerEntity player;
    final Hand hand;

    public PacketDeleteTeleportDestination(String name, PlayerEntity player, Hand hand) {
        this.name = name;
        this.player = player;
        this.hand = hand;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack stack = this.player.func_184586_b(this.hand);
        if (stack.func_77973_b() instanceof ItemAlchemicalBook) {
            try {
                IAlchemicalBookLocationsProvider provider = CapabilityAlchemicalBookLocations.from(stack);
                provider.ensureEditable((ServerPlayerEntity)this.player);
                provider.removeLocation(this.name);
                provider.sync((ServerPlayerEntity)this.player);
                provider.syncToOtherPlayers();
            }
            catch (CapabilityAlchemicalBookLocations.BookError error) {
                Util.sendSystemMessage(this.player, (ITextComponent)Lang.Items.ALCHEMICAL_BOOK_DELETE_FAILED.translateColored(TextFormatting.RED, new Object[]{error.getComponent()}));
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.name);
        buf.func_179252_a(this.player.func_110124_au());
        buf.func_179249_a((Enum)this.hand);
    }

    public static PacketDeleteTeleportDestination decode(PacketBuffer buf) {
        String name = buf.func_218666_n();
        UUID uuid = buf.func_179253_g();
        Hand hand = (Hand)buf.func_179257_a(Hand.class);
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            throw new IllegalStateException("Player not found in DeleteTeleportDestination packet");
        }
        return new PacketDeleteTeleportDestination(name, (PlayerEntity)player, hand);
    }
}

