/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.mixin;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.Enchantments;
import cool.furry.mc.forge.projectexpansion.registries.SoundEvents;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public abstract class AlchemicalCollectionMixin {
    @Inject(at={@At(value="RETURN")}, method={"getDrops(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;"}, cancellable=true)
    private static void getDrops(BlockState state, ServerWorld world, BlockPos pos, TileEntity tileEntity, Entity entity, ItemStack stack, CallbackInfoReturnable<List<ItemStack>> cir) {
        boolean hasEnch;
        if (!(entity instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        IKnowledgeProvider provider = Util.getKnowledgeProvider((PlayerEntity)player);
        if (provider == null) {
            return;
        }
        IEMCProxy proxy = ProjectEAPI.getEMCProxy();
        boolean bl = hasEnch = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)Enchantments.ALCHEMICAL_COLLECTION.get()), (ItemStack)stack) > 0;
        if (!state.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player) || !hasEnch) {
            return;
        }
        boolean enabled = stack.func_196082_o().func_74767_n(NBTNames.ALCHEMICAL_COLLECTION_ENABLED);
        if (!enabled) {
            return;
        }
        List initialDrops = (List)cir.getReturnValue();
        AtomicLong addEMC = new AtomicLong();
        ArrayList knowledgeAdditions = new ArrayList();
        List newDrops = initialDrops.stream().map(drop -> {
            if (proxy.hasValue(drop)) {
                addEMC.addAndGet(proxy.getValue(drop));
                if (!provider.hasKnowledge(drop) && !knowledgeAdditions.contains(drop)) {
                    knowledgeAdditions.add(drop);
                }
                return null;
            }
            return drop;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (newDrops.size() < initialDrops.size() || addEMC.get() > 0L) {
            provider.setEmc(provider.getEmc().add(BigInteger.valueOf(addEMC.get())));
            if (knowledgeAdditions.size() > 0) {
                knowledgeAdditions.forEach(knowledge -> {
                    if (provider.addKnowledge(knowledge)) {
                        provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)stack)), true);
                    }
                });
            }
            provider.syncEmc(player);
            if (((Boolean)Config.alchemicalCollectionSound.get()).booleanValue()) {
                world.func_184133_a(null, pos, (SoundEvent)SoundEvents.ALCHEMICAL_COLLECTION_COLLECT.get(), SoundCategory.BLOCKS, 1.0f, 0.75f);
            }
            cir.setReturnValue(newDrops);
        }
    }
}

